/*
 * Decompiled with CFR 0.152.
 */
package dev.youshallnotpass.inspection;

import com.github.javaparser.JavaParser;
import com.github.javaparser.ParseProblemException;
import com.github.javaparser.ParseResult;
import com.github.javaparser.Problem;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.body.TypeDeclaration;
import dev.youshallnotpass.inspection.InspectionBiFunc;
import dev.youshallnotpass.inspection.InspectionException;
import dev.youshallnotpass.inspection.InspectionScalar;
import dev.youshallnotpass.inspection.Violation;
import dev.youshallnotpass.inspection.Violations;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import org.cactoos.BiFunc;

public final class JavaViolations<T extends Violation>
implements Violations<T> {
    private final InspectionScalar<InputStream> source;
    private final JavaParser parser;
    private final String descriptor;
    private final InspectionBiFunc<CompilationUnit, TypeDeclaration<?>, List<T>> violations;

    public JavaViolations(JavaParser parser, BiFunc<CompilationUnit, TypeDeclaration<?>, List<T>> violations, String ... lines) {
        this(new InspectionScalar<InputStream>(() -> {
            StringBuilder source = new StringBuilder();
            for (String line : lines) {
                source.append(line);
            }
            return new ByteArrayInputStream(source.toString().getBytes(StandardCharsets.UTF_8));
        }), parser, String.join((CharSequence)"", lines), violations);
    }

    public JavaViolations(JavaParser parser, BiFunc<CompilationUnit, TypeDeclaration<?>, List<T>> violations, File file) {
        this(new InspectionScalar<InputStream>(() -> {
            try {
                return new FileInputStream(file);
            }
            catch (IOException e) {
                throw new InspectionException(String.format("Can not get an input stream from the file: %s", file), e);
            }
        }), parser, file.getAbsolutePath(), violations);
    }

    public JavaViolations(InspectionScalar<InputStream> source, JavaParser parser, String descriptor, BiFunc<CompilationUnit, TypeDeclaration<?>, List<T>> violations) {
        this(source, parser, descriptor, new InspectionBiFunc(violations));
    }

    public JavaViolations(InspectionScalar<InputStream> source, JavaParser parser, String descriptor, InspectionBiFunc<CompilationUnit, TypeDeclaration<?>, List<T>> violations) {
        this.source = source;
        this.parser = parser;
        this.descriptor = descriptor;
        this.violations = violations;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<T> asList() throws InspectionException {
        try (InputStream stream = this.source.value();){
            ArrayList result = new ArrayList();
            ParseResult parsed = this.parser.parse(stream);
            if (parsed.isSuccessful()) {
                CompilationUnit unit;
                Optional root;
                Optional optionalUnit = parsed.getResult();
                if (optionalUnit.isPresent() && (root = (unit = (CompilationUnit)optionalUnit.get()).findFirst(TypeDeclaration.class)).isPresent()) {
                    result.addAll(this.violations.apply(unit, (TypeDeclaration<?>)root.get()));
                }
            } else {
                StringBuilder problems = new StringBuilder();
                Iterator iterator = parsed.getProblems().iterator();
                while (true) {
                    if (!iterator.hasNext()) {
                        throw new InspectionException(String.format("Can not count violations in: '%s'. \nPlease, fix java syntax errors: \n%s", this.descriptor, problems.toString()));
                    }
                    Problem problem = (Problem)iterator.next();
                    problems.append(problem.toString());
                    problems.append("\n");
                }
            }
            ArrayList arrayList = result;
            return arrayList;
        }
        catch (IOException e) {
            throw new InspectionException(String.format("Can not count violations in: '%s'.", this.descriptor), e);
        }
        catch (ParseProblemException e) {
            throw new InspectionException(String.format("Can not count violations in: '%s'. \nPlease, fix java syntax errors and try again.", this.descriptor), e);
        }
    }
}

