/*
 * Decompiled with CFR 0.152.
 */
package dev.youshallnotpass.inspections.nullfree;

import dev.youshallnotpass.inspection.ExcludeSuppressed;
import dev.youshallnotpass.inspection.InspectionException;
import dev.youshallnotpass.inspection.InspectionFailures;
import dev.youshallnotpass.inspection.SimpleViolations;
import dev.youshallnotpass.inspection.Violations;
import dev.youshallnotpass.inspection.badge.YsnpBadge;
import dev.youshallnotpass.inspection.sources.SourceMask;
import dev.youshallnotpass.inspections.nullfree.nulls.ExcludeComparisons;
import dev.youshallnotpass.inspections.nullfree.nulls.JavaNulls;
import dev.youshallnotpass.inspections.nullfree.nulls.Null;
import dev.youshallnotpass.plugin.Failures;
import dev.youshallnotpass.plugin.Inspection;
import dev.youshallnotpass.plugin.YsnpException;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;

public final class Nullfree
implements Inspection {
    private final SourceMask sourceMask;
    private final boolean skipComparisons;
    private final int threshold;
    private final List<Null> nulls;

    public Nullfree(SourceMask sourceMask, boolean skipComparisons, int threshold) {
        this(sourceMask, skipComparisons, threshold, new ArrayList<Null>());
    }

    public Nullfree(SourceMask sourceMask, boolean skipComparisons, int threshold, List<Null> nulls) {
        this.sourceMask = sourceMask;
        this.skipComparisons = skipComparisons;
        this.threshold = threshold;
        this.nulls = nulls;
    }

    @Override
    public String name() {
        return "nullfree";
    }

    @Override
    public void accept(File file) throws YsnpException {
        Path path = file.toPath();
        if (this.sourceMask.matches(path)) {
            try {
                this.nulls.addAll(new JavaNulls(path.toFile()).asList());
            }
            catch (InspectionException e) {
                throw new YsnpException("Could not get the nulls.", e);
            }
        }
    }

    @Override
    public Failures failures() {
        Violations<Null> wrapped = this.skipComparisons ? new ExcludeComparisons(new ExcludeSuppressed<Null>(new SimpleViolations<Null>(this.nulls))) : new ExcludeSuppressed<Null>(new SimpleViolations<Null>(this.nulls));
        return new InspectionFailures<Null>(wrapped, new YsnpBadge(wrapped, this.threshold));
    }
}

