/*
 * Decompiled with CFR 0.152.
 */
package dev.youshallnotpass.inspections.nullfree.nulls;

import com.github.javaparser.JavaParser;
import com.github.javaparser.ParserConfiguration;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.body.TypeDeclaration;
import com.github.javaparser.ast.expr.NullLiteralExpr;
import dev.youshallnotpass.inspection.InspectionException;
import dev.youshallnotpass.inspection.InspectionScalar;
import dev.youshallnotpass.inspection.JavaViolations;
import dev.youshallnotpass.inspection.Violations;
import dev.youshallnotpass.inspections.nullfree.nulls.JavaNull;
import dev.youshallnotpass.inspections.nullfree.nulls.Null;
import dev.youshallnotpass.javaparser.NodeDescription;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;

public final class JavaNulls
implements Violations<Null> {
    private final Violations<Null> nulls;

    public JavaNulls(String ... lines) {
        this(ParserConfiguration.LanguageLevel.RAW, lines);
    }

    public JavaNulls(ParserConfiguration.LanguageLevel level, String ... lines) {
        this(new JavaParser(new ParserConfiguration().setLanguageLevel(level)), lines);
    }

    public JavaNulls(JavaParser parser, String ... lines) {
        this(parser, new InspectionScalar<InputStream>(() -> {
            StringBuilder source = new StringBuilder();
            for (String line : lines) {
                source.append(line);
            }
            return new ByteArrayInputStream(source.toString().getBytes(StandardCharsets.UTF_8));
        }), String.join((CharSequence)"", lines));
    }

    public JavaNulls(String source) {
        this(ParserConfiguration.LanguageLevel.RAW, source);
    }

    public JavaNulls(ParserConfiguration.LanguageLevel level, String source) {
        this(new JavaParser(new ParserConfiguration().setLanguageLevel(level)), source);
    }

    public JavaNulls(JavaParser parser, String source) {
        this(parser, new InspectionScalar<InputStream>(() -> new ByteArrayInputStream(source.getBytes(StandardCharsets.UTF_8))), source);
    }

    public JavaNulls(File file) {
        this(ParserConfiguration.LanguageLevel.RAW, file);
    }

    public JavaNulls(ParserConfiguration.LanguageLevel level, File file) {
        this(new JavaParser(new ParserConfiguration().setLanguageLevel(level)), file);
    }

    public JavaNulls(JavaParser parser, File file) {
        this(parser, new InspectionScalar<InputStream>(() -> {
            try {
                return new FileInputStream(file);
            }
            catch (IOException e) {
                throw new InspectionException(String.format("Can not get an input stream from the file: %s", file), e);
            }
        }), file.getAbsolutePath());
    }

    public JavaNulls(JavaParser parser, InspectionScalar<InputStream> source, String descriptor) {
        this(new JavaViolations<Null>(source, parser, descriptor, (unit, root) -> {
            ArrayList<JavaNull> result = new ArrayList<JavaNull>();
            List nulls = unit.findAll(NullLiteralExpr.class);
            for (NullLiteralExpr aNull : nulls) {
                result.add(new JavaNull(aNull, new NodeDescription((Node)aNull, (Node)aNull, (TypeDeclaration<?>)root)));
            }
            return result;
        }));
    }

    public JavaNulls(Violations<Null> nulls) {
        this.nulls = nulls;
    }

    @Override
    public List<Null> asList() throws InspectionException {
        return this.nulls.asList();
    }
}

