/*
 * Decompiled with CFR 0.152.
 */
package dev.youshallnotpass.inspections.setterfree;

import com.github.javaparser.JavaParser;
import com.github.javaparser.ParserConfiguration;
import dev.youshallnotpass.inspection.ExcludeSuppressed;
import dev.youshallnotpass.inspection.InspectionException;
import dev.youshallnotpass.inspection.InspectionFailures;
import dev.youshallnotpass.inspection.JavaViolations;
import dev.youshallnotpass.inspection.SimpleViolations;
import dev.youshallnotpass.inspection.badge.YsnpBadge;
import dev.youshallnotpass.inspection.sources.SourceMask;
import dev.youshallnotpass.inspections.setterfree.setters.Setter;
import dev.youshallnotpass.inspections.setterfree.setters.SetterViolations;
import dev.youshallnotpass.plugin.Failures;
import dev.youshallnotpass.plugin.Inspection;
import dev.youshallnotpass.plugin.YsnpException;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;

public final class SetterFree
implements Inspection {
    private final SourceMask sourceMask;
    private final int threshold;
    private final List<Setter> setters;

    public SetterFree(SourceMask sourceMask, int threshold) {
        this(sourceMask, threshold, new ArrayList<Setter>());
    }

    public SetterFree(SourceMask sourceMask, int threshold, List<Setter> setters) {
        this.sourceMask = sourceMask;
        this.threshold = threshold;
        this.setters = setters;
    }

    @Override
    public String name() {
        return "setterfree";
    }

    @Override
    public void accept(File file) throws YsnpException {
        Path path = file.toPath();
        if (this.sourceMask.matches(path)) {
            try {
                this.setters.addAll(new JavaViolations(new JavaParser(new ParserConfiguration().setLanguageLevel(ParserConfiguration.LanguageLevel.RAW)), new SetterViolations(), path.toFile()).asList());
            }
            catch (InspectionException e) {
                throw new YsnpException("Could not get the setters.", e);
            }
        }
    }

    @Override
    public Failures failures() {
        ExcludeSuppressed<Setter> setterViolations = new ExcludeSuppressed<Setter>(new SimpleViolations<Setter>(this.setters));
        return new InspectionFailures<Setter>(setterViolations, new YsnpBadge(setterViolations, this.threshold));
    }
}

