/*
 * Decompiled with CFR 0.152.
 */
package dev.youshallnotpass.inspections.setterfree.setters;

import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.FieldDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.body.Parameter;
import com.github.javaparser.ast.body.TypeDeclaration;
import com.github.javaparser.ast.body.VariableDeclarator;
import com.github.javaparser.ast.expr.AssignExpr;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.FieldAccessExpr;
import com.github.javaparser.ast.stmt.BlockStmt;
import com.github.javaparser.ast.stmt.Statement;
import dev.youshallnotpass.inspections.setterfree.setters.JavaSetter;
import dev.youshallnotpass.inspections.setterfree.setters.Setter;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.cactoos.BiFunc;

public final class SetterViolations
implements BiFunc<CompilationUnit, TypeDeclaration<?>, List<Setter>> {
    public List<Setter> apply(CompilationUnit unit, TypeDeclaration<?> root) {
        ArrayList<Setter> setters = new ArrayList<Setter>();
        List declarations = unit.findAll(ClassOrInterfaceDeclaration.class);
        for (ClassOrInterfaceDeclaration declaration : declarations) {
            ArrayList classFields = new ArrayList();
            ArrayList<MethodDeclaration> classMethods = new ArrayList<MethodDeclaration>();
            for (Node childNode : declaration.getChildNodes()) {
                FieldDeclaration field;
                if (childNode instanceof FieldDeclaration && !(field = (FieldDeclaration)childNode).isFinal()) {
                    classFields.addAll(field.getVariables());
                }
                if (!(childNode instanceof MethodDeclaration)) continue;
                MethodDeclaration method = (MethodDeclaration)childNode;
                classMethods.add(method);
            }
            for (MethodDeclaration method : classMethods) {
                boolean isPrivate = method.isPrivate();
                NodeList parameters = method.getParameters();
                Optional<AssignExpr> assignExprOpt = method.getBody().map(BlockStmt::getStatements).map(statements -> statements.stream().filter(statement -> !statement.isReturnStmt()).collect(Collectors.toList())).filter(statements -> statements.size() == 1).map(statements -> (Statement)statements.get(0)).filter(Statement::isExpressionStmt).map(statement -> statement.asExpressionStmt().getExpression()).filter(Expression::isAssignExpr).map(Expression::asAssignExpr);
                if (isPrivate || parameters.size() != 1 || !assignExprOpt.isPresent()) continue;
                Parameter methodArg = (Parameter)parameters.get(0);
                AssignExpr assignExpr = assignExprOpt.get();
                Expression target = assignExpr.getTarget();
                Expression value = assignExpr.getValue();
                if (!value.isNameExpr() || !value.asNameExpr().getNameAsString().equals(methodArg.getNameAsString())) continue;
                if (target.isFieldAccessExpr()) {
                    FieldAccessExpr fieldAccessExpr = target.asFieldAccessExpr();
                    Expression scope = fieldAccessExpr.getScope();
                    if (!scope.isThisExpr()) continue;
                    String fieldName = fieldAccessExpr.getNameAsString();
                    for (VariableDeclarator classField : classFields) {
                        if (!classField.getNameAsString().equals(fieldName)) continue;
                        setters.add(new JavaSetter(method, root));
                    }
                    continue;
                }
                if (!target.isNameExpr()) continue;
                String fieldName = target.asNameExpr().getNameAsString();
                for (VariableDeclarator classField : classFields) {
                    if (!classField.getNameAsString().equals(fieldName)) continue;
                    setters.add(new JavaSetter(method, root));
                }
            }
        }
        return setters;
    }
}

