/*
 * Decompiled with CFR 0.152.
 */
package dev.youshallnotpass.inspections.staticfree;

import dev.youshallnotpass.inspection.ExcludeSuppressed;
import dev.youshallnotpass.inspection.InspectionException;
import dev.youshallnotpass.inspection.InspectionFailures;
import dev.youshallnotpass.inspection.SimpleViolations;
import dev.youshallnotpass.inspection.badge.YsnpBadge;
import dev.youshallnotpass.inspection.sources.SourceMask;
import dev.youshallnotpass.inspections.staticfree.statics.JavaStatics;
import dev.youshallnotpass.inspections.staticfree.statics.Static;
import dev.youshallnotpass.plugin.Failures;
import dev.youshallnotpass.plugin.Inspection;
import dev.youshallnotpass.plugin.YsnpException;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;

public final class Staticfree
implements Inspection {
    private final SourceMask sourceMask;
    private final int threshold;
    private final List<Static> statics;

    public Staticfree(SourceMask sourceMask, int threshold) {
        this(sourceMask, threshold, new ArrayList<Static>());
    }

    public Staticfree(SourceMask sourceMask, int threshold, List<Static> statics) {
        this.sourceMask = sourceMask;
        this.threshold = threshold;
        this.statics = statics;
    }

    @Override
    public String name() {
        return "staticfree";
    }

    @Override
    public void accept(File file) throws YsnpException {
        Path path = file.toPath();
        if (this.sourceMask.matches(path)) {
            try {
                this.statics.addAll(new JavaStatics(path.toFile()).asList());
            }
            catch (InspectionException e) {
                throw new YsnpException("Could not get the statics.", e);
            }
        }
    }

    @Override
    public Failures failures() {
        ExcludeSuppressed<Static> statics = new ExcludeSuppressed<Static>(new SimpleViolations<Static>(this.statics));
        return new InspectionFailures<Static>(statics, new YsnpBadge(statics, this.threshold));
    }
}

