/*
 * Decompiled with CFR 0.152.
 */
package dev.youshallnotpass.inspections.staticfree.statics;

import com.github.javaparser.JavaParser;
import com.github.javaparser.ParserConfiguration;
import com.github.javaparser.ast.Modifier;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.body.TypeDeclaration;
import dev.youshallnotpass.inspection.InspectionException;
import dev.youshallnotpass.inspection.InspectionScalar;
import dev.youshallnotpass.inspection.JavaViolations;
import dev.youshallnotpass.inspection.Violations;
import dev.youshallnotpass.inspections.staticfree.statics.JavaStatic;
import dev.youshallnotpass.inspections.staticfree.statics.Static;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;

public final class JavaStatics
implements Violations<Static> {
    private final Violations<Static> statics;

    public JavaStatics(String ... lines) {
        this(ParserConfiguration.LanguageLevel.RAW, lines);
    }

    public JavaStatics(ParserConfiguration.LanguageLevel level, String ... lines) {
        this(new JavaParser(new ParserConfiguration().setLanguageLevel(level)), lines);
    }

    public JavaStatics(JavaParser parser, String ... lines) {
        this(parser, new InspectionScalar<InputStream>(() -> {
            StringBuilder source = new StringBuilder();
            for (String line : lines) {
                source.append(line);
            }
            return new ByteArrayInputStream(source.toString().getBytes(StandardCharsets.UTF_8));
        }), String.join((CharSequence)"", lines));
    }

    public JavaStatics(String source) {
        this(ParserConfiguration.LanguageLevel.RAW, source);
    }

    public JavaStatics(ParserConfiguration.LanguageLevel level, String source) {
        this(new JavaParser(new ParserConfiguration().setLanguageLevel(level)), source);
    }

    public JavaStatics(JavaParser parser, String source) {
        this(parser, new InspectionScalar<InputStream>(() -> new ByteArrayInputStream(source.getBytes(StandardCharsets.UTF_8))), source);
    }

    public JavaStatics(File file) {
        this(ParserConfiguration.LanguageLevel.RAW, file);
    }

    public JavaStatics(ParserConfiguration.LanguageLevel level, File file) {
        this(new JavaParser(new ParserConfiguration().setLanguageLevel(level)), file);
    }

    public JavaStatics(JavaParser parser, File file) {
        this(parser, new InspectionScalar<InputStream>(() -> {
            try {
                return new FileInputStream(file);
            }
            catch (IOException e) {
                throw new InspectionException(String.format("Can not get an input stream from the file: %s", file), e);
            }
        }), file.getAbsolutePath());
    }

    public JavaStatics(JavaParser parser, InspectionScalar<InputStream> source, String descriptor) {
        this(new JavaViolations<Static>(source, parser, descriptor, (unit, root) -> {
            ArrayList result = new ArrayList();
            unit.findAll(Modifier.class).stream().filter(modifier -> modifier.getKeyword() == Modifier.Keyword.STATIC).forEach(modifier -> result.add(new JavaStatic((Node)modifier, (TypeDeclaration<?>)root)));
            return result;
        }));
    }

    public JavaStatics(Violations<Static> statics) {
        this.statics = statics;
    }

    @Override
    public List<Static> asList() throws InspectionException {
        return this.statics.asList();
    }
}

