/*
 * Decompiled with CFR 0.152.
 */
package dev.youshallnotpass.javaparser;

import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.expr.AnnotationExpr;
import com.github.javaparser.ast.expr.StringLiteralExpr;
import com.github.javaparser.ast.nodeTypes.NodeWithAnnotations;
import dev.youshallnotpass.javaparser.Description;
import dev.youshallnotpass.javaparser.Item;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.cactoos.func.UncheckedBiFunc;

public final class NodeItem
implements Item {
    private final Node node;
    private final Description description;
    private final UncheckedBiFunc<Node, String, Boolean> isSuppressed;

    public NodeItem(Node origin, Description description) {
        this(origin, description, (UncheckedBiFunc<Node, String, Boolean>)new UncheckedBiFunc((node, name) -> {
            Optional suppressAnnotation;
            NodeWithAnnotations declaration;
            List<Boolean> result = Arrays.asList(false);
            if (node instanceof NodeWithAnnotations && (declaration = (NodeWithAnnotations)node).isAnnotationPresent("SuppressWarnings") && (suppressAnnotation = node.findFirst(AnnotationExpr.class, expr -> "SuppressWarnings".equals(expr.getNameAsString()))).isPresent()) {
                List values = ((AnnotationExpr)suppressAnnotation.get()).findAll(StringLiteralExpr.class);
                for (StringLiteralExpr value : values) {
                    if (!name.equals(value.asString())) continue;
                    result.set(0, true);
                }
            }
            return result.get(0);
        }));
    }

    public NodeItem(Node origin, Description description, UncheckedBiFunc<Node, String, Boolean> isSuppressed) {
        this.node = origin;
        this.description = description;
        this.isSuppressed = isSuppressed;
    }

    @Override
    public String description() {
        return this.description.asString();
    }

    @Override
    public boolean isSuppressed(String name) {
        List<Boolean> result = Arrays.asList(false);
        boolean currentSuppressed = (Boolean)this.isSuppressed.apply((Object)this.node, (Object)name);
        if (currentSuppressed) {
            result.set(0, true);
        } else {
            this.node.walk(Node.TreeTraversal.PARENTS, node -> {
                boolean suppressed = (Boolean)this.isSuppressed.apply(node, (Object)name);
                if (suppressed) {
                    result.set(0, true);
                }
            });
        }
        return result.get(0);
    }
}

