/*
 * Decompiled with CFR 0.152.
 */
package dev.youshallnotpass.javaparser;

import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.PackageDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.body.TypeDeclaration;
import com.github.javaparser.ast.expr.ObjectCreationExpr;
import dev.youshallnotpass.javaparser.Path;
import java.util.Optional;

public final class NodePath
implements Path {
    private final Node node;

    public NodePath(Node node) {
        this.node = node;
    }

    @Override
    public String asString() {
        Optional pkg;
        StringBuilder path = new StringBuilder();
        if (this.node instanceof TypeDeclaration) {
            path.insert(0, ((TypeDeclaration)this.node).getNameAsString());
            path.insert(0, '$');
        }
        if (this.node instanceof ObjectCreationExpr) {
            path.insert(0, ((ObjectCreationExpr)this.node).getType().getNameAsString());
            path.insert(0, '$');
        }
        if (this.node instanceof MethodDeclaration) {
            path.insert(0, ((MethodDeclaration)this.node).getNameAsString());
            path.insert(0, '.');
        }
        if (this.node instanceof CompilationUnit && (pkg = ((CompilationUnit)this.node).getPackageDeclaration()).isPresent()) {
            path.replace(0, 1, ".");
            path.insert(0, ((PackageDeclaration)pkg.get()).getNameAsString());
        }
        this.node.walk(Node.TreeTraversal.PARENTS, node -> {
            Optional pkg;
            if (node instanceof TypeDeclaration) {
                path.insert(0, ((TypeDeclaration)node).getNameAsString());
                path.insert(0, '$');
            }
            if (node instanceof ObjectCreationExpr) {
                path.insert(0, ((ObjectCreationExpr)node).getType().getNameAsString());
                path.insert(0, '$');
            }
            if (node instanceof MethodDeclaration) {
                path.insert(0, ((MethodDeclaration)node).getNameAsString());
                path.insert(0, '.');
            }
            if (node instanceof CompilationUnit && (pkg = ((CompilationUnit)node).getPackageDeclaration()).isPresent()) {
                path.replace(0, 1, ".");
                path.insert(0, ((PackageDeclaration)pkg.get()).getNameAsString());
            }
        });
        if (path.length() > 0 && path.charAt(0) == '$') {
            path.delete(0, 1);
        }
        return path.toString();
    }
}

