/*
 * Decompiled with CFR 0.152.
 */
package dev.youshallnotpass.plugin;

import dev.youshallnotpass.plugin.Failures;
import dev.youshallnotpass.plugin.Inspection;
import dev.youshallnotpass.plugin.Plugin;
import dev.youshallnotpass.plugin.Ui;
import dev.youshallnotpass.plugin.YsnpException;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.cactoos.Scalar;
import org.cactoos.iterable.Mapped;
import org.cactoos.map.MapEntry;
import org.cactoos.scalar.Solid;

public final class YsnpPlugin
implements Plugin {
    private final Ui ui;
    private final Scalar<List<File>> files;
    private final List<Inspection> inspections;

    public YsnpPlugin(Ui ui, File root, List<Inspection> inspections) {
        this(ui, (Scalar<List<File>>)new Solid(() -> {
            final ArrayList files = new ArrayList();
            try {
                Files.walkFileTree(root.toPath(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                        files.add(file.toFile());
                        return FileVisitResult.CONTINUE;
                    }
                });
            }
            catch (IOException e) {
                throw new YsnpException(String.format("Could not enumerate files in the %s", root), e);
            }
            return files;
        }), inspections);
    }

    public YsnpPlugin(Ui ui, Scalar<List<File>> files, List<Inspection> inspections) {
        this.ui = ui;
        this.files = files;
        this.inspections = inspections;
    }

    @Override
    public void run() throws YsnpException {
        try {
            for (File file : (List)this.files.value()) {
                for (Inspection inspection2 : this.inspections) {
                    inspection2.accept(file);
                }
            }
        }
        catch (Exception e) {
            throw new YsnpException("Could not inspect files. ", e);
        }
        Mapped failuresList = new Mapped(inspection -> new MapEntry((Object)inspection.name(), (Object)inspection.failures()), this.inspections);
        for (Map.Entry failures : failuresList) {
            this.ui.println((String)failures.getKey());
            ((Failures)failures.getValue()).show(this.ui);
            this.ui.println("");
        }
        for (Map.Entry failures : failuresList) {
            ((Failures)failures.getValue()).failIfRed();
        }
    }
}

