/*
 * Decompiled with CFR 0.152.
 */
package dev.zacsweers.moshix.reflect;

import dev.zacsweers.moshix.reflect.JvmDescriptorsKt;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.metadata.KmProperty;
import kotlinx.metadata.jvm.JvmExtensionsKt;
import kotlinx.metadata.jvm.JvmFieldSignature;
import kotlinx.metadata.jvm.JvmMethodSignature;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B\u0011\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u001c\u0010\t\u001a\u00020\u00062\n\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u00032\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u001c\u0010\r\u001a\u00020\u000e2\n\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u00032\u0006\u0010\u000b\u001a\u00020\u000fH\u0002J\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0007\u001a\u00020\bJ\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0007\u001a\u00020\bJ\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0007\u001a\u00020\bR\u0012\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Ldev/zacsweers/moshix/reflect/JvmSignatureSearcher;", "", "clazz", "Ljava/lang/Class;", "(Ljava/lang/Class;)V", "field", "Ljava/lang/reflect/Field;", "kmProperty", "Lkotlinx/metadata/KmProperty;", "findField", "sourceClass", "signature", "Lkotlinx/metadata/jvm/JvmFieldSignature;", "findMethod", "Ljava/lang/reflect/Method;", "Lkotlinx/metadata/jvm/JvmMethodSignature;", "getter", "setter", "syntheticMethodForAnnotations", "moshi-metadata-reflect"})
final class JvmSignatureSearcher {
    @NotNull
    private final Class<?> clazz;

    public JvmSignatureSearcher(@NotNull Class<?> clazz) {
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        this.clazz = clazz;
    }

    @Nullable
    public final Method syntheticMethodForAnnotations(@NotNull KmProperty kmProperty) {
        Method method;
        Intrinsics.checkNotNullParameter((Object)kmProperty, (String)"kmProperty");
        JvmMethodSignature jvmMethodSignature2 = JvmExtensionsKt.getSyntheticMethodForAnnotations((KmProperty)kmProperty);
        if (jvmMethodSignature2 != null) {
            JvmMethodSignature signature = jvmMethodSignature2;
            boolean bl = false;
            method = this.findMethod(this.clazz, signature);
        } else {
            method = null;
        }
        return method;
    }

    @Nullable
    public final Method getter(@NotNull KmProperty kmProperty) {
        Method method;
        Intrinsics.checkNotNullParameter((Object)kmProperty, (String)"kmProperty");
        JvmMethodSignature jvmMethodSignature2 = JvmExtensionsKt.getGetterSignature((KmProperty)kmProperty);
        if (jvmMethodSignature2 != null) {
            JvmMethodSignature signature = jvmMethodSignature2;
            boolean bl = false;
            method = this.findMethod(this.clazz, signature);
        } else {
            method = null;
        }
        return method;
    }

    @Nullable
    public final Method setter(@NotNull KmProperty kmProperty) {
        Method method;
        Intrinsics.checkNotNullParameter((Object)kmProperty, (String)"kmProperty");
        JvmMethodSignature jvmMethodSignature2 = JvmExtensionsKt.getSetterSignature((KmProperty)kmProperty);
        if (jvmMethodSignature2 != null) {
            JvmMethodSignature signature = jvmMethodSignature2;
            boolean bl = false;
            method = this.findMethod(this.clazz, signature);
        } else {
            method = null;
        }
        return method;
    }

    @Nullable
    public final Field field(@NotNull KmProperty kmProperty) {
        Field field;
        Intrinsics.checkNotNullParameter((Object)kmProperty, (String)"kmProperty");
        JvmFieldSignature jvmFieldSignature = JvmExtensionsKt.getFieldSignature((KmProperty)kmProperty);
        if (jvmFieldSignature != null) {
            JvmFieldSignature signature = jvmFieldSignature;
            boolean bl = false;
            field = this.findField(this.clazz, signature);
        } else {
            field = null;
        }
        return field;
    }

    private final Method findMethod(Class<?> sourceClass, JvmMethodSignature signature) {
        Method method;
        List<Class<?>> parameterTypes = JvmDescriptorsKt.decodeParameterTypes(signature);
        try {
            Method method2;
            if (parameterTypes.isEmpty()) {
                method2 = sourceClass.getDeclaredMethod(signature.getName(), new Class[0]);
            } else {
                String string = signature.getName();
                Collection $this$toTypedArray$iv = parameterTypes;
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                Class[] classArray = thisCollection$iv.toArray(new Class[0]);
                Intrinsics.checkNotNull((Object)classArray, (String)"null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
                Class[] classArray2 = classArray;
                method2 = sourceClass.getDeclaredMethod(string, Arrays.copyOf(classArray2, classArray2.length));
            }
            Intrinsics.checkNotNullExpressionValue((Object)method2, (String)"{\n      if (parameterTyp\u2026pedArray())\n      }\n    }");
            method = method2;
        }
        catch (NoSuchMethodException e) {
            Class<?> superClass = sourceClass.getSuperclass();
            if (!Intrinsics.areEqual(superClass, Object.class)) {
                Intrinsics.checkNotNullExpressionValue(superClass, (String)"superClass");
                return this.findMethod(superClass, signature);
            }
            throw e;
        }
        return method;
    }

    private final Field findField(Class<?> sourceClass, JvmFieldSignature signature) {
        Field field;
        try {
            Field field2 = sourceClass.getDeclaredField(signature.getName());
            Intrinsics.checkNotNullExpressionValue((Object)field2, (String)"{\n      sourceClass.getD\u2026eld(signature.name)\n    }");
            field = field2;
        }
        catch (NoSuchFieldException e) {
            Class<?> superClass = sourceClass.getSuperclass();
            if (!Intrinsics.areEqual(superClass, Object.class)) {
                Intrinsics.checkNotNullExpressionValue(superClass, (String)"superClass");
                return this.findField(superClass, signature);
            }
            throw e;
        }
        return field;
    }
}

