/*
 * Decompiled with CFR 0.152.
 */
package dev.zarr.zarrjava.store;

import com.squareup.okhttp.Call;
import com.squareup.okhttp.OkHttpClient;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import dev.zarr.zarrjava.store.Store;
import dev.zarr.zarrjava.store.StoreHandle;
import java.io.IOException;
import java.nio.ByteBuffer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class HttpStore
implements Store {
    @Nonnull
    private final OkHttpClient httpClient = new OkHttpClient();
    @Nonnull
    private final String uri;

    public HttpStore(@Nonnull String uri) {
        this.uri = uri;
    }

    String resolveKeys(String[] keys) {
        StringBuilder newUri = new StringBuilder(this.uri.replaceAll("\\/+$", ""));
        for (String key : keys) {
            newUri.append("/").append(key);
        }
        return newUri.toString();
    }

    @Nullable
    ByteBuffer get(Request request) {
        ByteBuffer byteBuffer;
        block8: {
            Call call = this.httpClient.newCall(request);
            Response response = call.execute();
            ResponseBody body = response.body();
            try {
                byteBuffer = ByteBuffer.wrap(body.bytes());
                if (body == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (body != null) {
                        try {
                            body.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    return null;
                }
            }
            body.close();
        }
        return byteBuffer;
    }

    @Override
    public boolean exists(String[] keys) {
        Request request = new Request.Builder().head().url(this.resolveKeys(keys)).build();
        Call call = this.httpClient.newCall(request);
        try {
            Response response = call.execute();
            return response.isSuccessful();
        }
        catch (IOException e) {
            return false;
        }
    }

    @Override
    @Nullable
    public ByteBuffer get(String[] keys) {
        Request request = new Request.Builder().url(this.resolveKeys(keys)).build();
        return this.get(request);
    }

    @Override
    @Nullable
    public ByteBuffer get(String[] keys, long start) {
        Request request = new Request.Builder().url(this.resolveKeys(keys)).header("Range", start < 0L ? String.format("Bytes=%d", start) : String.format("Bytes=%d-", start)).build();
        return this.get(request);
    }

    @Override
    @Nullable
    public ByteBuffer get(String[] keys, long start, long end) {
        if (start < 0L) {
            throw new IllegalArgumentException("Argument 'start' needs to be non-negative.");
        }
        Request request = new Request.Builder().url(this.resolveKeys(keys)).header("Range", String.format("Bytes=%d-%d", start, end + 1L)).build();
        return this.get(request);
    }

    @Override
    public void set(String[] keys, ByteBuffer bytes) {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public void delete(String[] keys) {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    @Nonnull
    public StoreHandle resolve(String ... keys) {
        return new StoreHandle(this, keys);
    }

    public String toString() {
        return this.uri;
    }
}

