/*
 * Decompiled with CFR 0.152.
 */
package dev.zarr.zarrjava.store;

import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.model.GetObjectRequest;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.S3ObjectInputStream;
import dev.zarr.zarrjava.store.Store;
import dev.zarr.zarrjava.store.StoreHandle;
import dev.zarr.zarrjava.utils.Utils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class S3Store
implements Store,
Store.ListableStore {
    @Nonnull
    private final AmazonS3 s3client;
    @Nonnull
    private final String bucketName;
    @Nullable
    private final String prefix;

    public S3Store(@Nonnull AmazonS3 s3client, @Nonnull String bucketName, @Nullable String prefix) {
        this.s3client = s3client;
        this.bucketName = bucketName;
        this.prefix = prefix;
    }

    String resolveKeys(String[] keys) {
        if (this.prefix == null) {
            return String.join((CharSequence)"/", keys);
        }
        if (keys == null || keys.length == 0) {
            return this.prefix;
        }
        return this.prefix + "/" + String.join((CharSequence)"/", keys);
    }

    @Nullable
    ByteBuffer get(GetObjectRequest getObjectRequest) {
        ByteBuffer byteBuffer;
        block8: {
            S3ObjectInputStream inputStream = this.s3client.getObject(getObjectRequest).getObjectContent();
            try {
                byteBuffer = Utils.asByteBuffer((InputStream)inputStream);
                if (inputStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    return null;
                }
            }
            inputStream.close();
        }
        return byteBuffer;
    }

    @Override
    public boolean exists(String[] keys) {
        return this.s3client.doesObjectExist(this.bucketName, this.resolveKeys(keys));
    }

    @Override
    @Nullable
    public ByteBuffer get(String[] keys) {
        return this.get(new GetObjectRequest(this.bucketName, this.resolveKeys(keys)));
    }

    @Override
    @Nullable
    public ByteBuffer get(String[] keys, long start) {
        return this.get(new GetObjectRequest(this.bucketName, this.resolveKeys(keys)).withRange(start));
    }

    @Override
    @Nullable
    public ByteBuffer get(String[] keys, long start, long end) {
        return this.get(new GetObjectRequest(this.bucketName, this.resolveKeys(keys)).withRange(start, end));
    }

    @Override
    public void set(String[] keys, ByteBuffer bytes) {
        try (ByteArrayInputStream byteStream = new ByteArrayInputStream(Utils.toArray(bytes));){
            this.s3client.putObject(this.bucketName, this.resolveKeys(keys), (InputStream)byteStream, new ObjectMetadata());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void delete(String[] keys) {
        this.s3client.deleteObject(this.bucketName, this.resolveKeys(keys));
    }

    @Override
    public Stream<String> list(String[] keys) {
        String fullKey = this.resolveKeys(keys);
        return this.s3client.listObjects(this.bucketName, fullKey).getObjectSummaries().stream().map(p -> p.getKey().substring(fullKey.length() + 1));
    }

    @Override
    @Nonnull
    public StoreHandle resolve(String ... keys) {
        return new StoreHandle(this, keys);
    }

    public String toString() {
        return "s3://" + this.bucketName + "/" + this.prefix;
    }
}

