/*
 * Decompiled with CFR 0.152.
 */
package dev.zarr.zarrjava.store;

import dev.zarr.zarrjava.store.Store;
import dev.zarr.zarrjava.utils.Utils;
import java.nio.ByteBuffer;
import java.nio.file.NoSuchFileException;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class StoreHandle {
    @Nonnull
    final Store store;
    @Nonnull
    final String[] keys;

    public StoreHandle(@Nonnull Store store, String ... keys) {
        this.store = store;
        this.keys = keys;
    }

    @Nullable
    public ByteBuffer read() {
        return this.store.get(this.keys);
    }

    @Nonnull
    public ByteBuffer readNonNull() throws NoSuchFileException {
        ByteBuffer bytes = this.read();
        if (bytes == null) {
            throw new NoSuchFileException(this.toString());
        }
        return bytes;
    }

    @Nullable
    public ByteBuffer read(long start) {
        return this.store.get(this.keys, start);
    }

    @Nullable
    public ByteBuffer read(long start, long end) {
        return this.store.get(this.keys, start, end);
    }

    public void set(ByteBuffer bytes) {
        this.store.set(this.keys, bytes);
    }

    public void delete() {
        this.store.delete(this.keys);
    }

    public boolean exists() {
        return this.store.exists(this.keys);
    }

    public Stream<String> list() {
        if (!(this.store instanceof Store.ListableStore)) {
            throw new UnsupportedOperationException("The underlying store does not support listing.");
        }
        return ((Store.ListableStore)this.store).list(this.keys);
    }

    public String toString() {
        return this.store + "/" + String.join((CharSequence)"/", this.keys);
    }

    public StoreHandle resolve(String ... subKeys) {
        return new StoreHandle(this.store, Utils.concatArrays(this.keys, new String[][]{subKeys}));
    }
}

