/*
 * Decompiled with CFR 0.152.
 */
package dev.zarr.zarrjava.v2;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import dev.zarr.zarrjava.store.StoreHandle;
import dev.zarr.zarrjava.utils.Utils;
import dev.zarr.zarrjava.v2.ArrayMetadata;
import java.io.IOException;
import java.util.Arrays;
import java.util.stream.Collectors;

public class Array {
    static final String ZARRAY = ".zarray";
    public ArrayMetadata metadata;
    public StoreHandle storeHandle;

    Array(StoreHandle storeHandle) throws IOException {
        this.storeHandle = storeHandle;
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.registerModule((Module)new Jdk8Module());
        this.metadata = (ArrayMetadata)objectMapper.readValue(Utils.toArray(storeHandle.resolve(ZARRAY).readNonNull()), ArrayMetadata.class);
    }

    public static Array open(StoreHandle storeHandle) throws IOException {
        return new Array(storeHandle);
    }

    public String toString() {
        return String.format("<v2.Array {%s} (%s) %s>", new Object[]{this.storeHandle, Arrays.stream(this.metadata.shape).mapToObj(Long::toString).collect(Collectors.joining(", ")), this.metadata.dataType});
    }
}

