/*
 * Decompiled with CFR 0.152.
 */
package dev.zarr.zarrjava.v3;

import com.fasterxml.jackson.databind.ObjectMapper;
import dev.zarr.zarrjava.ZarrException;
import dev.zarr.zarrjava.store.StoreHandle;
import dev.zarr.zarrjava.utils.IndexingUtils;
import dev.zarr.zarrjava.utils.MultiArrayUtils;
import dev.zarr.zarrjava.utils.Utils;
import dev.zarr.zarrjava.v3.ArrayMetadata;
import dev.zarr.zarrjava.v3.ArrayMetadataBuilder;
import dev.zarr.zarrjava.v3.Node;
import dev.zarr.zarrjava.v3.codec.CodecPipeline;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import ucar.ma2.DataType;
import ucar.ma2.InvalidRangeException;

public class Array
extends Node {
    public ArrayMetadata metadata;
    CodecPipeline codecPipeline;

    protected Array(StoreHandle storeHandle, ArrayMetadata arrayMetadata) throws IOException, ZarrException {
        super(storeHandle);
        this.metadata = arrayMetadata;
        this.codecPipeline = new CodecPipeline(arrayMetadata.codecs, arrayMetadata.coreArrayMetadata);
    }

    public static Array open(StoreHandle storeHandle) throws IOException, ZarrException {
        return new Array(storeHandle, (ArrayMetadata)Array.makeObjectMapper().readValue(Utils.toArray(storeHandle.resolve("zarr.json").readNonNull()), ArrayMetadata.class));
    }

    public static Array create(StoreHandle storeHandle, ArrayMetadata arrayMetadata) throws IOException, ZarrException {
        return Array.create(storeHandle, arrayMetadata, false);
    }

    public static Array create(StoreHandle storeHandle, ArrayMetadata arrayMetadata, boolean existsOk) throws IOException, ZarrException {
        StoreHandle metadataHandle = storeHandle.resolve("zarr.json");
        if (!existsOk && metadataHandle.exists()) {
            throw new RuntimeException("Trying to create a new array in " + storeHandle + ". But " + metadataHandle + " already exists.");
        }
        ObjectMapper objectMapper = Array.makeObjectMapper();
        ByteBuffer metadataBytes = ByteBuffer.wrap(objectMapper.writeValueAsBytes((Object)arrayMetadata));
        metadataHandle.set(metadataBytes);
        return new Array(storeHandle, arrayMetadata);
    }

    public static Array create(StoreHandle storeHandle, Function<ArrayMetadataBuilder, ArrayMetadataBuilder> arrayMetadataBuilderMapper, boolean existsOk) throws IOException, ZarrException {
        return Array.create(storeHandle, arrayMetadataBuilderMapper.apply(new ArrayMetadataBuilder()).build(), existsOk);
    }

    @Nonnull
    public static ArrayMetadataBuilder metadataBuilder() {
        return new ArrayMetadataBuilder();
    }

    @Nonnull
    public static ArrayMetadataBuilder metadataBuilder(ArrayMetadata existingMetadata) {
        return ArrayMetadataBuilder.fromArrayMetadata(existingMetadata);
    }

    @Nonnull
    public ucar.ma2.Array read() throws ZarrException {
        return this.read(new long[this.metadata.ndim()], Utils.toIntArray(this.metadata.shape));
    }

    @Nonnull
    public ucar.ma2.Array read(long[] offset, int[] shape) throws ZarrException {
        if (offset.length != this.metadata.ndim()) {
            throw new IllegalArgumentException("'offset' needs to have rank '" + this.metadata.ndim() + "'.");
        }
        if (shape.length != this.metadata.ndim()) {
            throw new IllegalArgumentException("'shape' needs to have rank '" + this.metadata.ndim() + "'.");
        }
        int[] chunkShape = this.metadata.chunkShape();
        if (IndexingUtils.isSingleFullChunk(offset, shape, chunkShape)) {
            return this.readChunk(IndexingUtils.computeSingleChunkCoords(offset, chunkShape));
        }
        ucar.ma2.Array outputArray = ucar.ma2.Array.factory((DataType)this.metadata.dataType.getMA2DataType(), (int[])shape);
        Arrays.stream(IndexingUtils.computeChunkCoords(this.metadata.shape, chunkShape, offset, shape)).forEach(chunkCoords -> {
            try {
                IndexingUtils.ChunkProjection chunkProjection = IndexingUtils.computeProjection(chunkCoords, this.metadata.shape, chunkShape, offset, shape);
                if (this.chunkIsInArray((long[])chunkCoords)) {
                    MultiArrayUtils.copyRegion(this.metadata.allocateFillValueChunk(), chunkProjection.chunkOffset, outputArray, chunkProjection.outOffset, chunkProjection.shape);
                }
                String[] chunkKeys = this.metadata.chunkKeyEncoding.encodeChunkKey((long[])chunkCoords);
                StoreHandle chunkHandle = this.storeHandle.resolve(chunkKeys);
                if (this.codecPipeline.supportsPartialDecode()) {
                    ucar.ma2.Array chunkArray = this.codecPipeline.decodePartial(chunkHandle, Utils.toLongArray(chunkProjection.chunkOffset), chunkProjection.shape);
                    MultiArrayUtils.copyRegion(chunkArray, new int[this.metadata.ndim()], outputArray, chunkProjection.outOffset, chunkProjection.shape);
                } else {
                    MultiArrayUtils.copyRegion(this.readChunk((long[])chunkCoords), chunkProjection.chunkOffset, outputArray, chunkProjection.outOffset, chunkProjection.shape);
                }
            }
            catch (ZarrException e) {
                throw new RuntimeException(e);
            }
        });
        return outputArray;
    }

    boolean chunkIsInArray(long[] chunkCoords) {
        int[] chunkShape = this.metadata.chunkShape();
        for (int dimIdx = 0; dimIdx < this.metadata.ndim(); ++dimIdx) {
            if (chunkCoords[dimIdx] >= 0L && chunkCoords[dimIdx] * (long)chunkShape[dimIdx] < this.metadata.shape[dimIdx]) continue;
            return false;
        }
        return true;
    }

    @Nonnull
    public ucar.ma2.Array readChunk(long[] chunkCoords) throws ZarrException {
        if (!this.chunkIsInArray(chunkCoords)) {
            throw new ZarrException("Attempting to read data outside of the array's domain.");
        }
        String[] chunkKeys = this.metadata.chunkKeyEncoding.encodeChunkKey(chunkCoords);
        StoreHandle chunkHandle = this.storeHandle.resolve(chunkKeys);
        ByteBuffer chunkBytes = chunkHandle.read();
        if (chunkBytes == null) {
            return this.metadata.allocateFillValueChunk();
        }
        return this.codecPipeline.decode(chunkBytes);
    }

    public void write(ucar.ma2.Array array) {
        this.write(new long[this.metadata.ndim()], array);
    }

    public void write(long[] offset, ucar.ma2.Array array) {
        if (offset.length != this.metadata.ndim()) {
            throw new IllegalArgumentException("'offset' needs to have rank '" + this.metadata.ndim() + "'.");
        }
        if (array.getRank() != this.metadata.ndim()) {
            throw new IllegalArgumentException("'array' needs to have rank '" + this.metadata.ndim() + "'.");
        }
        int[] shape = array.getShape();
        int[] chunkShape = this.metadata.chunkShape();
        Arrays.stream(IndexingUtils.computeChunkCoords(this.metadata.shape, chunkShape, offset, shape)).forEach(chunkCoords -> {
            try {
                ucar.ma2.Array chunkArray;
                IndexingUtils.ChunkProjection chunkProjection = IndexingUtils.computeProjection(chunkCoords, this.metadata.shape, chunkShape, offset, shape);
                if (IndexingUtils.isFullChunk(chunkProjection.chunkOffset, chunkProjection.shape, chunkShape)) {
                    chunkArray = array.sectionNoReduce(chunkProjection.outOffset, chunkProjection.shape, null);
                } else {
                    chunkArray = this.readChunk((long[])chunkCoords);
                    MultiArrayUtils.copyRegion(array, chunkProjection.outOffset, chunkArray, chunkProjection.chunkOffset, chunkProjection.shape);
                }
                this.writeChunk((long[])chunkCoords, chunkArray);
            }
            catch (ZarrException | InvalidRangeException e) {
                throw new RuntimeException(e);
            }
        });
    }

    public void writeChunk(long[] chunkCoords, ucar.ma2.Array chunkArray) throws ZarrException {
        String[] chunkKeys = this.metadata.chunkKeyEncoding.encodeChunkKey(chunkCoords);
        StoreHandle chunkHandle = this.storeHandle.resolve(chunkKeys);
        if (MultiArrayUtils.allValuesEqual(chunkArray, this.metadata.parsedFillValue)) {
            chunkHandle.delete();
        } else {
            ByteBuffer chunkBytes = this.codecPipeline.encode(chunkArray);
            chunkHandle.set(chunkBytes);
        }
    }

    public ArrayAccessor access() {
        return new ArrayAccessor(this);
    }

    private Array writeMetadata(ArrayMetadata newArrayMetadata) throws ZarrException, IOException {
        ObjectMapper objectMapper = Array.makeObjectMapper();
        ByteBuffer metadataBytes = ByteBuffer.wrap(objectMapper.writeValueAsBytes((Object)newArrayMetadata));
        this.storeHandle.resolve("zarr.json").set(metadataBytes);
        return new Array(this.storeHandle, newArrayMetadata);
    }

    public Array resize(long[] newShape) throws ZarrException, IOException {
        if (newShape.length != this.metadata.ndim()) {
            throw new IllegalArgumentException("'newShape' needs to have rank '" + this.metadata.ndim() + "'.");
        }
        ArrayMetadata newArrayMetadata = ArrayMetadataBuilder.fromArrayMetadata(this.metadata).withShape(newShape).build();
        return this.writeMetadata(newArrayMetadata);
    }

    public Array setAttributes(Map<String, Object> newAttributes) throws ZarrException, IOException {
        ArrayMetadata newArrayMetadata = ArrayMetadataBuilder.fromArrayMetadata(this.metadata).withAttributes(newAttributes).build();
        return this.writeMetadata(newArrayMetadata);
    }

    public Array updateAttributes(Function<Map<String, Object>, Map<String, Object>> attributeMapper) throws ZarrException, IOException {
        return this.setAttributes(attributeMapper.apply((Map<String, Object>)new HashMap<String, Object>(this.metadata.attributes){}));
    }

    public String toString() {
        return String.format("<v3.Array {%s} (%s) %s>", new Object[]{this.storeHandle, Arrays.stream(this.metadata.shape).mapToObj(Long::toString).collect(Collectors.joining(", ")), this.metadata.dataType});
    }

    public static final class ArrayAccessor {
        @Nullable
        long[] offset;
        @Nullable
        int[] shape;
        @Nonnull
        Array array;

        private ArrayAccessor(@Nonnull Array array) {
            this.array = array;
        }

        @Nonnull
        public ArrayAccessor withOffset(long ... offset) {
            this.offset = offset;
            return this;
        }

        @Nonnull
        public ArrayAccessor withShape(int ... shape) {
            this.shape = shape;
            return this;
        }

        @Nonnull
        public ArrayAccessor withShape(long ... shape) {
            this.shape = Utils.toIntArray(shape);
            return this;
        }

        @Nonnull
        public ucar.ma2.Array read() throws ZarrException {
            if (this.offset == null) {
                throw new ZarrException("`offset` needs to be set.");
            }
            if (this.shape == null) {
                throw new ZarrException("`shape` needs to be set.");
            }
            return this.array.read(this.offset, this.shape);
        }

        public void write(@Nonnull ucar.ma2.Array content) throws ZarrException {
            if (this.offset == null) {
                throw new ZarrException("`offset` needs to be set.");
            }
            this.array.write(this.offset, content);
        }
    }
}

