/*
 * Decompiled with CFR 0.152.
 */
package dev.zarr.zarrjava.v3.codec.core;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import dev.zarr.zarrjava.ZarrException;
import dev.zarr.zarrjava.v3.ArrayMetadata;
import dev.zarr.zarrjava.v3.codec.ArrayBytesCodec;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import javax.annotation.Nonnull;
import ucar.ma2.Array;
import ucar.ma2.DataType;

public class BytesCodec
extends ArrayBytesCodec {
    public final String name = "bytes";
    @Nonnull
    public final Configuration configuration;

    @JsonCreator
    public BytesCodec(@Nonnull @JsonProperty(value="configuration", required=true) Configuration configuration) {
        this.configuration = configuration;
    }

    public BytesCodec(Endian endian) {
        this(new Configuration(endian));
    }

    @Override
    public Array decode(ByteBuffer chunkBytes) {
        chunkBytes.order(this.configuration.endian.getByteOrder());
        return Array.factory((DataType)this.arrayMetadata.dataType.getMA2DataType(), (int[])this.arrayMetadata.chunkShape, (ByteBuffer)chunkBytes);
    }

    @Override
    public ByteBuffer encode(Array chunkArray) {
        return chunkArray.getDataAsByteBuffer(this.configuration.endian.getByteOrder());
    }

    @Override
    public long computeEncodedSize(long inputByteLength, ArrayMetadata.CoreArrayMetadata arrayMetadata) throws ZarrException {
        return inputByteLength;
    }

    public static final class Configuration {
        @Nonnull
        public final Endian endian;

        @JsonCreator
        public Configuration(@JsonProperty(value="endian", defaultValue="little") Endian endian) {
            this.endian = endian;
        }
    }

    public static enum Endian {
        LITTLE("little"),
        BIG("big");

        private final String endian;

        private Endian(String endian) {
            this.endian = endian;
        }

        @JsonValue
        public String getValue() {
            return this.endian;
        }

        public ByteOrder getByteOrder() {
            switch (this) {
                case LITTLE: {
                    return ByteOrder.LITTLE_ENDIAN;
                }
                case BIG: {
                    return ByteOrder.BIG_ENDIAN;
                }
            }
            throw new RuntimeException("Unreachable");
        }
    }
}

