/*
 * Decompiled with CFR 0.152.
 */
package dev.zarr.zarrjava.v3.codec.core;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import dev.zarr.zarrjava.ZarrException;
import dev.zarr.zarrjava.utils.Utils;
import dev.zarr.zarrjava.v3.ArrayMetadata;
import dev.zarr.zarrjava.v3.codec.ArrayArrayCodec;
import java.util.Arrays;
import javax.annotation.Nonnull;
import ucar.ma2.Array;

public class TransposeCodec
extends ArrayArrayCodec {
    @Nonnull
    public final String name = "transpose";
    @Nonnull
    public final Configuration configuration;

    @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
    public TransposeCodec(@Nonnull @JsonProperty(value="configuration", required=true) Configuration configuration) {
        this.configuration = configuration;
    }

    @Override
    public Array decode(Array chunkArray) throws ZarrException {
        if (!Utils.isPermutation(this.configuration.order)) {
            throw new ZarrException("Order is no permutation array");
        }
        if (this.arrayMetadata.ndim() != this.configuration.order.length) {
            throw new ZarrException("Array has not the same ndim as transpose codec order");
        }
        chunkArray = chunkArray.permute(Utils.inversePermutation(this.configuration.order));
        return chunkArray;
    }

    @Override
    public Array encode(Array chunkArray) throws ZarrException {
        if (!Utils.isPermutation(this.configuration.order)) {
            throw new ZarrException("Order is no permutation array");
        }
        if (this.arrayMetadata.ndim() != this.configuration.order.length) {
            throw new ZarrException("Array has not the same ndim as transpose codec order");
        }
        chunkArray = chunkArray.permute(this.configuration.order);
        return chunkArray;
    }

    @Override
    public long computeEncodedSize(long inputByteLength, ArrayMetadata.CoreArrayMetadata arrayMetadata) throws ZarrException {
        return inputByteLength;
    }

    @Override
    protected ArrayMetadata.CoreArrayMetadata resolveArrayMetadata() throws ZarrException {
        super.resolveArrayMetadata();
        assert (this.arrayMetadata.ndim() == this.configuration.order.length);
        int[] transposedChunkShape = new int[this.arrayMetadata.ndim()];
        Arrays.setAll(transposedChunkShape, i -> this.arrayMetadata.chunkShape[this.configuration.order[i]]);
        long[] transposedArrayShape = new long[this.arrayMetadata.ndim()];
        Arrays.setAll(transposedArrayShape, i -> this.arrayMetadata.shape[i] / (long)this.arrayMetadata.chunkShape[i] * transposedArrayShape[i]);
        return new ArrayMetadata.CoreArrayMetadata(transposedArrayShape, transposedChunkShape, this.arrayMetadata.dataType, this.arrayMetadata.parsedFillValue);
    }

    public static final class Configuration {
        public final int[] order;

        @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
        public Configuration(@JsonProperty(value="order") int[] order) {
            this.order = order;
        }
    }
}

