/*
 * Decompiled with CFR 0.152.
 */
package izumi.reflect.thirdparty.internal.boopickle;

import izumi.reflect.thirdparty.internal.boopickle.StringCodecBase;
import izumi.reflect.thirdparty.internal.boopickle.TextDecoder;
import izumi.reflect.thirdparty.internal.boopickle.TextEncoder;
import java.io.Serializable;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import scala.Function1;
import scala.collection.immutable.Seq;
import scala.math.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.scalajs.js.;
import scala.scalajs.js.Any;
import scala.scalajs.js.Array;
import scala.scalajs.js.Dynamic;
import scala.scalajs.js.typedarray.ArrayBufferView;
import scala.scalajs.js.typedarray.Int8Array;
import scala.scalajs.js.typedarray.Int8Array$;
import scala.scalajs.js.typedarray.TypedArrayBuffer$;
import scala.scalajs.js.typedarray.TypedArrayBufferOps$;
import scala.scalajs.js.typedarray.Uint16Array;

public final class JSStringCodec$
extends StringCodecBase {
    public static final JSStringCodec$ MODULE$ = new JSStringCodec$();
    private static Function1<Int8Array, String> utf8decoder;
    private static Function1<String, Int8Array> utf8encoder;
    private static Function1<Uint16Array, String> utf16decoder;
    private static Function1<String, Int8Array> utf16encoder;
    private static volatile byte bitmap$0;

    private Function1<Int8Array, String> utf8decoder$lzycompute() {
        synchronized (this) {
            if ((byte)(bitmap$0 & 1) == 0) {
                utf8decoder = arg_0 -> JSStringCodec$.$anonfun$utf8decoder$1(new TextDecoder((.bar<String, BoxedUnit>)scala.scalajs.js.package$.MODULE$.undefined()), arg_0);
                bitmap$0 = (byte)(bitmap$0 | 1);
            }
        }
        return utf8decoder;
    }

    private Function1<Int8Array, String> utf8decoder() {
        if ((byte)(bitmap$0 & 1) == 0) {
            return this.utf8decoder$lzycompute();
        }
        return utf8decoder;
    }

    private Function1<String, Int8Array> utf8encoder$lzycompute() {
        synchronized (this) {
            if ((byte)(bitmap$0 & 2) == 0) {
                utf8encoder = arg_0 -> JSStringCodec$.$anonfun$utf8encoder$1(new TextEncoder((.bar<String, BoxedUnit>)scala.scalajs.js.package$.MODULE$.undefined()), arg_0);
                bitmap$0 = (byte)(bitmap$0 | 2);
            }
        }
        return utf8encoder;
    }

    private Function1<String, Int8Array> utf8encoder() {
        if ((byte)(bitmap$0 & 2) == 0) {
            return this.utf8encoder$lzycompute();
        }
        return utf8encoder;
    }

    private Function1<Uint16Array, String> utf16decoder$lzycompute() {
        synchronized (this) {
            if ((byte)(bitmap$0 & 4) == 0) {
                utf16decoder = (Function1 & Serializable)data -> (String)Dynamic.global$.MODULE$.selectDynamic("String").selectDynamic("fromCharCode").applyDynamic("apply", (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Any[]{null, data}));
                bitmap$0 = (byte)(bitmap$0 | 4);
            }
        }
        return utf16decoder;
    }

    private Function1<Uint16Array, String> utf16decoder() {
        if ((byte)(bitmap$0 & 4) == 0) {
            return this.utf16decoder$lzycompute();
        }
        return utf16decoder;
    }

    private Function1<String, Int8Array> utf16encoder$lzycompute() {
        synchronized (this) {
            if ((byte)(bitmap$0 & 8) == 0) {
                utf16encoder = (Function1 & Serializable)str -> {
                    Uint16Array ta = new Uint16Array(str.length());
                    for (int i = 0; i < str.length(); ++i) {
                        ta.update(i, (Object)BoxesRunTime.boxToInteger((int)str.charAt(i)));
                    }
                    return new Int8Array(ta.buffer(), Int8Array$.MODULE$.$lessinit$greater$default$2(), Int8Array$.MODULE$.$lessinit$greater$default$3());
                };
                bitmap$0 = (byte)(bitmap$0 | 8);
            }
        }
        return utf16encoder;
    }

    private Function1<String, Int8Array> utf16encoder() {
        if ((byte)(bitmap$0 & 8) == 0) {
            return this.utf16encoder$lzycompute();
        }
        return utf16encoder;
    }

    @Override
    public String decodeUTF8(int len, ByteBuffer buf) {
        if (buf.isDirect() && !scala.scalajs.js.package$.MODULE$.isUndefined((Object)Dynamic.global$.MODULE$.selectDynamic("TextDecoder"))) {
            Int8Array ta = (Int8Array)TypedArrayBufferOps$.MODULE$.typedArray$extension(TypedArrayBufferOps$.MODULE$.byteBufferOps(buf));
            String s = (String)this.utf8decoder().apply(ta.subarray(buf.position(), buf.position() + len));
            ((Buffer)buf).position(buf.position() + len);
            return s;
        }
        byte[] a = new byte[len];
        buf.get(a);
        return new String(a, StandardCharsets.UTF_8);
    }

    @Override
    public ByteBuffer encodeUTF8(String str) {
        if (scala.scalajs.js.package$.MODULE$.isUndefined((Object)Dynamic.global$.MODULE$.selectDynamic("TextEncoder"))) {
            return ByteBuffer.wrap(str.getBytes(StandardCharsets.UTF_8));
        }
        return TypedArrayBuffer$.MODULE$.wrap((Int8Array)this.utf8encoder().apply((Object)str));
    }

    @Override
    public String decodeUTF16(int len, ByteBuffer buf) {
        if (buf.isDirect()) {
            Uint16Array ta = new Uint16Array(TypedArrayBufferOps$.MODULE$.typedArray$extension(TypedArrayBufferOps$.MODULE$.byteBufferOps(buf)).buffer(), buf.position() + TypedArrayBufferOps$.MODULE$.typedArray$extension(TypedArrayBufferOps$.MODULE$.byteBufferOps(buf)).byteOffset(), len / 2);
            ((Buffer)buf).position(buf.position() + len);
            return (String)this.utf16decoder().apply((Object)ta);
        }
        byte[] a = new byte[len];
        buf.get(a);
        return new String(a, StandardCharsets.UTF_16LE);
    }

    @Override
    public ByteBuffer encodeUTF16(String str) {
        return TypedArrayBuffer$.MODULE$.wrap((Int8Array)this.utf16encoder().apply((Object)str));
    }

    @Override
    public String decodeFast(int len, ByteBuffer buf) {
        if (buf.hasArray()) {
            return this.decodeFastArray(len, buf);
        }
        return this.decodeFastTypedArray(len, buf);
    }

    @Override
    public void encodeFast(String s, ByteBuffer bb) {
        if (bb.hasArray()) {
            this.encodeFastArray(s, bb);
            return;
        }
        this.encodeFastTypedArray(s, bb);
    }

    public void encodeFastTypedArray(String s, ByteBuffer bb) {
        char c;
        int len = s.length();
        Int8Array buf = (Int8Array)TypedArrayBufferOps$.MODULE$.typedArray$extension(TypedArrayBufferOps$.MODULE$.byteBufferOps(bb));
        int dst = bb.position();
        int src = 0;
        while (src < len && (c = s.charAt(src)) < '\u0080') {
            buf.update(dst, (Object)BoxesRunTime.boxToByte((byte)((byte)c)));
            ++src;
            ++dst;
        }
        while (src < len) {
            c = s.charAt(src);
            if (c < '\u0080') {
                buf.update(dst, (Object)BoxesRunTime.boxToByte((byte)((byte)c)));
                ++dst;
            } else if (c < '\u4000') {
                buf.update(dst, (Object)BoxesRunTime.boxToByte((byte)((byte)(0x80 | c & 0x3F))));
                buf.update(dst + 1, (Object)BoxesRunTime.boxToByte((byte)((byte)(c >> 6 & 0xFF))));
                dst += 2;
            } else {
                buf.update(dst, (Object)BoxesRunTime.boxToByte((byte)((byte)(0xC0 | c & 0x3F))));
                buf.update(dst + 1, (Object)BoxesRunTime.boxToByte((byte)((byte)(c >> 6 & 0xFF))));
                buf.update(dst + 2, (Object)BoxesRunTime.boxToByte((byte)((byte)(c >> 14))));
                dst += 3;
            }
            ++src;
        }
        ((Buffer)bb).position(dst);
    }

    private String charArray2String(Array<Object> chars, int offset, int len) {
        return (String)Dynamic.global$.MODULE$.selectDynamic("String").selectDynamic("fromCharCode").applyDynamic("apply", (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Any[]{null, chars.jsSlice(offset, offset + len)}));
    }

    public String decodeFastTypedArray(int len, ByteBuffer buf) {
        Array cp = new Array(len);
        Int8Array src = (Int8Array)TypedArrayBufferOps$.MODULE$.typedArray$extension(TypedArrayBufferOps$.MODULE$.byteBufferOps(buf));
        int offset = buf.position();
        for (int dst = 0; dst < len; ++dst) {
            int b = BoxesRunTime.unboxToByte((Object)src.apply(offset)) & 0xFF;
            ++offset;
            if ((b & 0x80) == 0) {
                cp.update(dst, (Object)BoxesRunTime.boxToInteger((int)b));
                continue;
            }
            if ((b & 0xC0) == 128) {
                int b1 = BoxesRunTime.unboxToByte((Object)src.apply(offset)) & 0xFF;
                ++offset;
                cp.update(dst, (Object)BoxesRunTime.boxToInteger((int)(b & 0x3F | b1 << 6)));
                continue;
            }
            int b1 = BoxesRunTime.unboxToByte((Object)src.apply(offset)) & 0xFF;
            int b2 = BoxesRunTime.unboxToByte((Object)src.apply(offset + 1)) & 0xFF;
            offset += 2;
            cp.update(dst, (Object)BoxesRunTime.boxToInteger((int)(b & 0x3F | b1 << 6 | b2 << 14)));
        }
        ((Buffer)buf).position(offset);
        if (len > 4096) {
            String s = "";
            for (offset = 0; offset < len; offset += 4096) {
                s = new StringBuilder(0).append(s).append(this.charArray2String((Array<Object>)cp, offset, package$.MODULE$.min(4096, len - offset))).toString();
            }
            return s;
        }
        return this.charArray2String((Array<Object>)cp, 0, len);
    }

    public static final /* synthetic */ String $anonfun$utf8decoder$1(TextDecoder td$1, Int8Array data) {
        return td$1.decode((ArrayBufferView)data);
    }

    public static final /* synthetic */ Int8Array $anonfun$utf8encoder$1(TextEncoder te$1, String str) {
        return new Int8Array(te$1.encode(str));
    }

    private JSStringCodec$() {
    }
}

