/*
 * Decompiled with CFR 0.152.
 */
package izumi.reflect.thirdparty.internal.boopickle;

import izumi.reflect.thirdparty.internal.boopickle.StringCodecBase;
import izumi.reflect.thirdparty.internal.boopickle.TextDecoder;
import izumi.reflect.thirdparty.internal.boopickle.TextDecoder$;
import izumi.reflect.thirdparty.internal.boopickle.TextEncoder;
import izumi.reflect.thirdparty.internal.boopickle.TextEncoder$;
import java.io.Serializable;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import scala.Function1;
import scala.collection.immutable.Seq;
import scala.math.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.scalajs.js.Any;
import scala.scalajs.js.Array;
import scala.scalajs.js.Dynamic;
import scala.scalajs.js.typedarray.ArrayBufferView;
import scala.scalajs.js.typedarray.Int8Array;
import scala.scalajs.js.typedarray.Int8Array$;
import scala.scalajs.js.typedarray.TypedArrayBuffer$;
import scala.scalajs.js.typedarray.TypedArrayBufferOps$;
import scala.scalajs.js.typedarray.Uint16Array;

public final class JSStringCodec$
extends StringCodecBase
implements Serializable {
    private static Function1 utf8decoder$lzy1;
    private boolean utf8decoderbitmap$1;
    private static Function1 utf8encoder$lzy1;
    private boolean utf8encoderbitmap$1;
    private static Function1 utf16decoder$lzy1;
    private boolean utf16decoderbitmap$1;
    private static Function1 utf16encoder$lzy1;
    private boolean utf16encoderbitmap$1;
    public static final JSStringCodec$ MODULE$;

    private JSStringCodec$() {
    }

    static {
        MODULE$ = new JSStringCodec$();
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(JSStringCodec$.class);
    }

    private Function1<Int8Array, String> utf8decoder() {
        if (!this.utf8decoderbitmap$1) {
            TextDecoder td = new TextDecoder(TextDecoder$.MODULE$.$lessinit$greater$default$1());
            utf8decoder$lzy1 = (Function1 & Serializable)data -> td.decode((ArrayBufferView)data);
            this.utf8decoderbitmap$1 = true;
        }
        return utf8decoder$lzy1;
    }

    private Function1<String, Int8Array> utf8encoder() {
        if (!this.utf8encoderbitmap$1) {
            TextEncoder te = new TextEncoder(TextEncoder$.MODULE$.$lessinit$greater$default$1());
            utf8encoder$lzy1 = (Function1 & Serializable)str -> new Int8Array(te.encode((String)str));
            this.utf8encoderbitmap$1 = true;
        }
        return utf8encoder$lzy1;
    }

    private Function1<Uint16Array, String> utf16decoder() {
        if (!this.utf16decoderbitmap$1) {
            utf16decoder$lzy1 = (Function1 & Serializable)data -> (String)Dynamic.global$.MODULE$.selectDynamic("String").selectDynamic("fromCharCode").applyDynamic("apply", (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Any[]{null, data}));
            this.utf16decoderbitmap$1 = true;
        }
        return utf16decoder$lzy1;
    }

    private Function1<String, Int8Array> utf16encoder() {
        if (!this.utf16encoderbitmap$1) {
            utf16encoder$lzy1 = (Function1 & Serializable)str -> {
                Uint16Array ta = new Uint16Array(str.length());
                for (int i = 0; i < str.length(); ++i) {
                    ta.update(i, (Object)BoxesRunTime.boxToInteger((int)str.charAt(i)));
                }
                return new Int8Array(ta.buffer(), Int8Array$.MODULE$.$lessinit$greater$default$2(), Int8Array$.MODULE$.$lessinit$greater$default$3());
            };
            this.utf16encoderbitmap$1 = true;
        }
        return utf16encoder$lzy1;
    }

    @Override
    public String decodeUTF8(int len, ByteBuffer buf) {
        if (buf.isDirect() && !scala.scalajs.js.package$.MODULE$.isUndefined((Object)Dynamic.global$.MODULE$.selectDynamic("TextDecoder"))) {
            Buffer buffer = TypedArrayBufferOps$.MODULE$.byteBufferOps(buf);
            Int8Array ta = (Int8Array)TypedArrayBufferOps$.MODULE$.typedArray$extension(buffer);
            String s = (String)this.utf8decoder().apply(ta.subarray(buf.position(), buf.position() + len));
            ((Buffer)buf).position(buf.position() + len);
            return s;
        }
        byte[] a = new byte[len];
        buf.get(a);
        return new String(a, StandardCharsets.UTF_8);
    }

    @Override
    public ByteBuffer encodeUTF8(String str) {
        if (scala.scalajs.js.package$.MODULE$.isUndefined((Object)Dynamic.global$.MODULE$.selectDynamic("TextEncoder"))) {
            return ByteBuffer.wrap(str.getBytes(StandardCharsets.UTF_8));
        }
        return TypedArrayBuffer$.MODULE$.wrap((Int8Array)this.utf8encoder().apply((Object)str));
    }

    @Override
    public String decodeUTF16(int len, ByteBuffer buf) {
        if (buf.isDirect()) {
            Buffer buffer = TypedArrayBufferOps$.MODULE$.byteBufferOps(buf);
            Buffer buffer2 = TypedArrayBufferOps$.MODULE$.byteBufferOps(buf);
            Uint16Array ta = new Uint16Array(TypedArrayBufferOps$.MODULE$.typedArray$extension(buffer).buffer(), buf.position() + TypedArrayBufferOps$.MODULE$.typedArray$extension(buffer2).byteOffset(), len / 2);
            ((Buffer)buf).position(buf.position() + len);
            return (String)this.utf16decoder().apply((Object)ta);
        }
        byte[] a = new byte[len];
        buf.get(a);
        return new String(a, StandardCharsets.UTF_16LE);
    }

    @Override
    public ByteBuffer encodeUTF16(String str) {
        return TypedArrayBuffer$.MODULE$.wrap((Int8Array)this.utf16encoder().apply((Object)str));
    }

    @Override
    public String decodeFast(int len, ByteBuffer buf) {
        if (buf.hasArray()) {
            return this.decodeFastArray(len, buf);
        }
        return this.decodeFastTypedArray(len, buf);
    }

    @Override
    public void encodeFast(String s, ByteBuffer bb) {
        if (bb.hasArray()) {
            this.encodeFastArray(s, bb);
            return;
        }
        this.encodeFastTypedArray(s, bb);
    }

    public void encodeFastTypedArray(String s, ByteBuffer bb) {
        int len = s.length();
        Buffer buffer = TypedArrayBufferOps$.MODULE$.byteBufferOps(bb);
        Int8Array buf = (Int8Array)TypedArrayBufferOps$.MODULE$.typedArray$extension(buffer);
        int dst = bb.position();
        int src = 0;
        int c = 32;
        while (src < len && (c = (int)s.charAt(src)) < 128) {
            buf.update(dst, (Object)BoxesRunTime.boxToByte((byte)((byte)c)));
            ++src;
            ++dst;
        }
        while (src < len) {
            c = s.charAt(src);
            if (c < 128) {
                buf.update(dst, (Object)BoxesRunTime.boxToByte((byte)((byte)c)));
                ++dst;
            } else if (c < 16384) {
                buf.update(dst, (Object)BoxesRunTime.boxToByte((byte)((byte)(0x80 | c & 0x3F))));
                buf.update(dst + 1, (Object)BoxesRunTime.boxToByte((byte)((byte)(c >> 6 & 0xFF))));
                dst += 2;
            } else {
                buf.update(dst, (Object)BoxesRunTime.boxToByte((byte)((byte)(0xC0 | c & 0x3F))));
                buf.update(dst + 1, (Object)BoxesRunTime.boxToByte((byte)((byte)(c >> 6 & 0xFF))));
                buf.update(dst + 2, (Object)BoxesRunTime.boxToByte((byte)((byte)(c >> 14))));
                dst += 3;
            }
            ++src;
        }
        ((Buffer)bb).position(dst);
    }

    private String charArray2String(Array<Object> chars, int offset, int len) {
        return (String)Dynamic.global$.MODULE$.selectDynamic("String").selectDynamic("fromCharCode").applyDynamic("apply", (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Any[]{null, chars.jsSlice(offset, offset + len)}));
    }

    public String decodeFastTypedArray(int len, ByteBuffer buf) {
        Array cp = new Array(len);
        Buffer buffer = TypedArrayBufferOps$.MODULE$.byteBufferOps(buf);
        Int8Array src = (Int8Array)TypedArrayBufferOps$.MODULE$.typedArray$extension(buffer);
        int offset = buf.position();
        for (int dst = 0; dst < len; ++dst) {
            int b = BoxesRunTime.unboxToByte((Object)src.apply(offset)) & 0xFF;
            ++offset;
            if ((b & 0x80) == 0) {
                cp.update(dst, (Object)BoxesRunTime.boxToInteger((int)b));
                continue;
            }
            if ((b & 0xC0) == 128) {
                int b1 = BoxesRunTime.unboxToByte((Object)src.apply(offset)) & 0xFF;
                ++offset;
                cp.update(dst, (Object)BoxesRunTime.boxToInteger((int)(b & 0x3F | b1 << 6)));
                continue;
            }
            int b1 = BoxesRunTime.unboxToByte((Object)src.apply(offset)) & 0xFF;
            int b2 = BoxesRunTime.unboxToByte((Object)src.apply(offset + 1)) & 0xFF;
            offset += 2;
            cp.update(dst, (Object)BoxesRunTime.boxToInteger((int)(b & 0x3F | b1 << 6 | b2 << 14)));
        }
        ((Buffer)buf).position(offset);
        if (len > 4096) {
            String s = "";
            for (offset = 0; offset < len; offset += 4096) {
                s = new StringBuilder(0).append(s).append(this.charArray2String((Array<Object>)cp, offset, package$.MODULE$.min(4096, len - offset))).toString();
            }
            return s;
        }
        return this.charArray2String((Array<Object>)cp, 0, len);
    }
}

