package zio.aws.account
import zio.aws.account.model.GetRegionOptStatusResponse.ReadOnly
import zio.aws.core.config.AwsConfig
import zio.aws.core.{AwsServiceBase, AwsError}
import zio.aws.account.model.{
  DeleteAlternateContactRequest,
  ListRegionsRequest,
  GetContactInformationRequest,
  GetRegionOptStatusRequest,
  DisableRegionRequest,
  PutContactInformationRequest,
  GetAlternateContactRequest,
  EnableRegionRequest,
  PutAlternateContactRequest
}
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import zio.{ZEnvironment, IO, ZIO, ZLayer, Scope}
import software.amazon.awssdk.services.account.model.{
  DeleteAlternateContactResponse,
  ListRegionsResponse,
  EnableRegionResponse,
  DisableRegionResponse,
  GetContactInformationResponse,
  GetRegionOptStatusResponse,
  PutContactInformationResponse,
  Region,
  GetAlternateContactResponse,
  PutAlternateContactResponse
}
import zio.stream.ZStream
import software.amazon.awssdk.services.account.{
  AccountAsyncClientBuilder,
  AccountAsyncClient
}
import scala.jdk.CollectionConverters.*
trait Account extends AspectSupport[Account] {
  val api: AccountAsyncClient
  def enableRegion(request: EnableRegionRequest): IO[AwsError, Unit]
  def getRegionOptStatus(
      request: GetRegionOptStatusRequest
  ): IO[AwsError, ReadOnly]
  def putContactInformation(
      request: PutContactInformationRequest
  ): IO[AwsError, Unit]
  def disableRegion(request: DisableRegionRequest): IO[AwsError, Unit]
  def getContactInformation(
      request: GetContactInformationRequest
  ): IO[AwsError, zio.aws.account.model.GetContactInformationResponse.ReadOnly]
  def deleteAlternateContact(
      request: DeleteAlternateContactRequest
  ): IO[AwsError, Unit]
  def putAlternateContact(
      request: PutAlternateContactRequest
  ): IO[AwsError, Unit]
  def listRegions(
      request: ListRegionsRequest
  ): ZStream[Any, AwsError, zio.aws.account.model.Region.ReadOnly]
  def listRegionsPaginated(
      request: ListRegionsRequest
  ): IO[AwsError, zio.aws.account.model.ListRegionsResponse.ReadOnly]
  def getAlternateContact(
      request: GetAlternateContactRequest
  ): IO[AwsError, zio.aws.account.model.GetAlternateContactResponse.ReadOnly]
}
object Account {
  val live: ZLayer[AwsConfig, java.lang.Throwable, Account] = customized(
    identity
  )
  def customized(
      customization: AccountAsyncClientBuilder => AccountAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, Account] =
    ZLayer.scoped(scoped(customization))
  def scoped(
      customization: AccountAsyncClientBuilder => AccountAsyncClientBuilder
  ): ZIO[AwsConfig with Scope, java.lang.Throwable, Account] = for (
    awsConfig <- ZIO.service[AwsConfig]; executor <- ZIO.executor;
    builder = AccountAsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig.configure[AccountAsyncClient, AccountAsyncClientBuilder](
      builder
    );
    b1 <- awsConfig
      .configureHttpClient[AccountAsyncClient, AccountAsyncClientBuilder](
        b0,
        zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
      ); client <- ZIO.attempt(customization(b1).build())
  ) yield new AccountImpl(client, AwsCallAspect.identity, ZEnvironment.empty)
  private class AccountImpl[R](
      override val api: AccountAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends Account
      with AwsServiceBase[R] {
    override val serviceName: String = "Account"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): AccountImpl[R1] = new AccountImpl(api, newAspect, r)
    def enableRegion(request: EnableRegionRequest): IO[AwsError, Unit] =
      asyncRequestResponse[
        software.amazon.awssdk.services.account.model.EnableRegionRequest,
        EnableRegionResponse
      ]("enableRegion", api.enableRegion)(request.buildAwsValue()).unit
        .provideEnvironment(r)
    def getRegionOptStatus(
        request: GetRegionOptStatusRequest
    ): IO[AwsError, ReadOnly] = asyncRequestResponse[
      software.amazon.awssdk.services.account.model.GetRegionOptStatusRequest,
      GetRegionOptStatusResponse
    ]("getRegionOptStatus", api.getRegionOptStatus)(request.buildAwsValue())
      .map(zio.aws.account.model.GetRegionOptStatusResponse.wrap)
      .provideEnvironment(r)
    def putContactInformation(
        request: PutContactInformationRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.account.model.PutContactInformationRequest,
      PutContactInformationResponse
    ]("putContactInformation", api.putContactInformation)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def disableRegion(request: DisableRegionRequest): IO[AwsError, Unit] =
      asyncRequestResponse[
        software.amazon.awssdk.services.account.model.DisableRegionRequest,
        DisableRegionResponse
      ]("disableRegion", api.disableRegion)(request.buildAwsValue()).unit
        .provideEnvironment(r)
    def getContactInformation(request: GetContactInformationRequest): IO[
      AwsError,
      zio.aws.account.model.GetContactInformationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.account.model.GetContactInformationRequest,
      GetContactInformationResponse
    ]("getContactInformation", api.getContactInformation)(
      request.buildAwsValue()
    ).map(zio.aws.account.model.GetContactInformationResponse.wrap)
      .provideEnvironment(r)
    def deleteAlternateContact(
        request: DeleteAlternateContactRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.account.model.DeleteAlternateContactRequest,
      DeleteAlternateContactResponse
    ]("deleteAlternateContact", api.deleteAlternateContact)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def putAlternateContact(
        request: PutAlternateContactRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.account.model.PutAlternateContactRequest,
      PutAlternateContactResponse
    ]("putAlternateContact", api.putAlternateContact)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def listRegions(
        request: ListRegionsRequest
    ): ZStream[Any, AwsError, zio.aws.account.model.Region.ReadOnly] =
      asyncSimplePaginatedRequest[
        software.amazon.awssdk.services.account.model.ListRegionsRequest,
        ListRegionsResponse,
        Region
      ](
        "listRegions",
        api.listRegions,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.regions().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.account.model.Region.wrap(item))
        .provideEnvironment(r)
    def listRegionsPaginated(
        request: ListRegionsRequest
    ): IO[AwsError, zio.aws.account.model.ListRegionsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.account.model.ListRegionsRequest,
        ListRegionsResponse
      ]("listRegions", api.listRegions)(request.buildAwsValue())
        .map(zio.aws.account.model.ListRegionsResponse.wrap)
        .provideEnvironment(r)
    def getAlternateContact(request: GetAlternateContactRequest): IO[
      AwsError,
      zio.aws.account.model.GetAlternateContactResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.account.model.GetAlternateContactRequest,
      GetAlternateContactResponse
    ]("getAlternateContact", api.getAlternateContact)(request.buildAwsValue())
      .map(zio.aws.account.model.GetAlternateContactResponse.wrap)
      .provideEnvironment(r)
  }
  def enableRegion(
      request: EnableRegionRequest
  ): ZIO[zio.aws.account.Account, AwsError, Unit] =
    ZIO.serviceWithZIO(_.enableRegion(request))
  def getRegionOptStatus(
      request: GetRegionOptStatusRequest
  ): ZIO[zio.aws.account.Account, AwsError, ReadOnly] =
    ZIO.serviceWithZIO(_.getRegionOptStatus(request))
  def putContactInformation(
      request: PutContactInformationRequest
  ): ZIO[zio.aws.account.Account, AwsError, Unit] =
    ZIO.serviceWithZIO(_.putContactInformation(request))
  def disableRegion(
      request: DisableRegionRequest
  ): ZIO[zio.aws.account.Account, AwsError, Unit] =
    ZIO.serviceWithZIO(_.disableRegion(request))
  def getContactInformation(request: GetContactInformationRequest): ZIO[
    zio.aws.account.Account,
    AwsError,
    zio.aws.account.model.GetContactInformationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getContactInformation(request))
  def deleteAlternateContact(
      request: DeleteAlternateContactRequest
  ): ZIO[zio.aws.account.Account, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteAlternateContact(request))
  def putAlternateContact(
      request: PutAlternateContactRequest
  ): ZIO[zio.aws.account.Account, AwsError, Unit] =
    ZIO.serviceWithZIO(_.putAlternateContact(request))
  def listRegions(request: ListRegionsRequest): ZStream[
    zio.aws.account.Account,
    AwsError,
    zio.aws.account.model.Region.ReadOnly
  ] = ZStream.serviceWithStream(_.listRegions(request))
  def listRegionsPaginated(request: ListRegionsRequest): ZIO[
    zio.aws.account.Account,
    AwsError,
    zio.aws.account.model.ListRegionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listRegionsPaginated(request))
  def getAlternateContact(request: GetAlternateContactRequest): ZIO[
    zio.aws.account.Account,
    AwsError,
    zio.aws.account.model.GetAlternateContactResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getAlternateContact(request))
}
