package zio.aws.account
import zio.aws.account.model.GetRegionOptStatusResponse.ReadOnly
import zio.mock.{Proxy, Mock}
import zio.aws.core.AwsError
import zio.aws.account.model.{
  DeleteAlternateContactRequest,
  ListRegionsRequest,
  GetContactInformationRequest,
  GetRegionOptStatusRequest,
  DisableRegionRequest,
  PutContactInformationRequest,
  GetAlternateContactRequest,
  EnableRegionRequest,
  PutAlternateContactRequest
}
import zio.aws.core.aspects.AwsCallAspect
import zio.{IO, ZEnvironment, URLayer}
import zio.stream.ZStream
import software.amazon.awssdk.services.account.AccountAsyncClient
object AccountMock extends Mock[Account] {
  object EnableRegion extends Effect[EnableRegionRequest, AwsError, Unit]
  object GetRegionOptStatus
      extends Effect[GetRegionOptStatusRequest, AwsError, ReadOnly]
  object PutContactInformation
      extends Effect[PutContactInformationRequest, AwsError, Unit]
  object DisableRegion extends Effect[DisableRegionRequest, AwsError, Unit]
  object GetContactInformation
      extends Effect[
        GetContactInformationRequest,
        AwsError,
        zio.aws.account.model.GetContactInformationResponse.ReadOnly
      ]
  object DeleteAlternateContact
      extends Effect[DeleteAlternateContactRequest, AwsError, Unit]
  object PutAlternateContact
      extends Effect[PutAlternateContactRequest, AwsError, Unit]
  object ListRegions
      extends Stream[
        ListRegionsRequest,
        AwsError,
        zio.aws.account.model.Region.ReadOnly
      ]
  object ListRegionsPaginated
      extends Effect[
        ListRegionsRequest,
        AwsError,
        zio.aws.account.model.ListRegionsResponse.ReadOnly
      ]
  object GetAlternateContact
      extends Effect[
        GetAlternateContactRequest,
        AwsError,
        zio.aws.account.model.GetAlternateContactResponse.ReadOnly
      ]
  val compose: URLayer[Proxy, Account] = zio.ZLayer {
    zio.ZIO.service[Proxy].flatMap { proxy =>
      withRuntime[Proxy, Account] { rts =>
        zio.ZIO.succeed {
          new Account {
            val api: AccountAsyncClient = null
            def withAspect[R1](
                newAspect: AwsCallAspect[R1],
                r: ZEnvironment[R1]
            ): Account = this
            def enableRegion(request: EnableRegionRequest): IO[AwsError, Unit] =
              proxy(EnableRegion, request)
            def getRegionOptStatus(
                request: GetRegionOptStatusRequest
            ): IO[AwsError, ReadOnly] = proxy(GetRegionOptStatus, request)
            def putContactInformation(
                request: PutContactInformationRequest
            ): IO[AwsError, Unit] = proxy(PutContactInformation, request)
            def disableRegion(
                request: DisableRegionRequest
            ): IO[AwsError, Unit] = proxy(DisableRegion, request)
            def getContactInformation(
                request: GetContactInformationRequest
            ): IO[
              AwsError,
              zio.aws.account.model.GetContactInformationResponse.ReadOnly
            ] = proxy(GetContactInformation, request)
            def deleteAlternateContact(
                request: DeleteAlternateContactRequest
            ): IO[AwsError, Unit] = proxy(DeleteAlternateContact, request)
            def putAlternateContact(
                request: PutAlternateContactRequest
            ): IO[AwsError, Unit] = proxy(PutAlternateContact, request)
            def listRegions(
                request: ListRegionsRequest
            ): ZStream[Any, AwsError, zio.aws.account.model.Region.ReadOnly] =
              zio.Unsafe.unsafe { implicit u =>
                rts.unsafe
                  .run {
                    proxy(ListRegions, request)
                  }
                  .getOrThrowFiberFailure()
              }
            def listRegionsPaginated(request: ListRegionsRequest): IO[
              AwsError,
              zio.aws.account.model.ListRegionsResponse.ReadOnly
            ] = proxy(ListRegionsPaginated, request)
            def getAlternateContact(request: GetAlternateContactRequest): IO[
              AwsError,
              zio.aws.account.model.GetAlternateContactResponse.ReadOnly
            ] = proxy(GetAlternateContact, request)
          }
        }
      }
    }
  }
}
