package zio.aws.account.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.account.model.primitives.{Title, PhoneNumber, Name, EmailAddress}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class AlternateContact(
    alternateContactType: Optional[zio.aws.account.model.AlternateContactType] =
      Optional.Absent,
    emailAddress: Optional[EmailAddress] = Optional.Absent,
    name: Optional[Name] = Optional.Absent,
    phoneNumber: Optional[PhoneNumber] = Optional.Absent,
    title: Optional[Title] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.account.model.AlternateContact = {
    import AlternateContact.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.account.model.AlternateContact
      .builder()
      .optionallyWith(alternateContactType.map(value => value.unwrap))(
        _.alternateContactType
      )
      .optionallyWith(
        emailAddress.map(value => EmailAddress.unwrap(value): java.lang.String)
      )(_.emailAddress)
      .optionallyWith(name.map(value => Name.unwrap(value): java.lang.String))(
        _.name
      )
      .optionallyWith(
        phoneNumber.map(value => PhoneNumber.unwrap(value): java.lang.String)
      )(_.phoneNumber)
      .optionallyWith(
        title.map(value => Title.unwrap(value): java.lang.String)
      )(_.title)
      .build()
  }
  def asReadOnly: zio.aws.account.model.AlternateContact.ReadOnly =
    zio.aws.account.model.AlternateContact.wrap(buildAwsValue())
}
object AlternateContact {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.account.model.AlternateContact
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.account.model.AlternateContact =
      zio.aws.account.model.AlternateContact(
        alternateContactType.map(value => value),
        emailAddress.map(value => value),
        name.map(value => value),
        phoneNumber.map(value => value),
        title.map(value => value)
      )
    def alternateContactType
        : Optional[zio.aws.account.model.AlternateContactType]
    def emailAddress: Optional[EmailAddress]
    def name: Optional[Name]
    def phoneNumber: Optional[PhoneNumber]
    def title: Optional[Title]
    def getAlternateContactType
        : ZIO[Any, AwsError, zio.aws.account.model.AlternateContactType] =
      AwsError.unwrapOptionField("alternateContactType", alternateContactType)
    def getEmailAddress: ZIO[Any, AwsError, EmailAddress] =
      AwsError.unwrapOptionField("emailAddress", emailAddress)
    def getName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("name", name)
    def getPhoneNumber: ZIO[Any, AwsError, PhoneNumber] =
      AwsError.unwrapOptionField("phoneNumber", phoneNumber)
    def getTitle: ZIO[Any, AwsError, Title] =
      AwsError.unwrapOptionField("title", title)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.account.model.AlternateContact
  ) extends zio.aws.account.model.AlternateContact.ReadOnly {
    override val alternateContactType
        : Optional[zio.aws.account.model.AlternateContactType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.alternateContactType())
        .map(value => zio.aws.account.model.AlternateContactType.wrap(value))
    override val emailAddress: Optional[EmailAddress] = zio.aws.core.internal
      .optionalFromNullable(impl.emailAddress())
      .map(value => zio.aws.account.model.primitives.EmailAddress(value))
    override val name: Optional[Name] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.account.model.primitives.Name(value))
    override val phoneNumber: Optional[PhoneNumber] = zio.aws.core.internal
      .optionalFromNullable(impl.phoneNumber())
      .map(value => zio.aws.account.model.primitives.PhoneNumber(value))
    override val title: Optional[Title] = zio.aws.core.internal
      .optionalFromNullable(impl.title())
      .map(value => zio.aws.account.model.primitives.Title(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.account.model.AlternateContact
  ): zio.aws.account.model.AlternateContact.ReadOnly = new Wrapper(impl)
}
