package zio.aws.account.model
import scala.jdk.CollectionConverters.*
sealed trait AlternateContactType {
  def unwrap: software.amazon.awssdk.services.account.model.AlternateContactType
}
object AlternateContactType {
  def wrap(
      value: software.amazon.awssdk.services.account.model.AlternateContactType
  ): zio.aws.account.model.AlternateContactType = value match {
    case software.amazon.awssdk.services.account.model.AlternateContactType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.account.model.AlternateContactType.BILLING =>
      val r = BILLING
      r
    case software.amazon.awssdk.services.account.model.AlternateContactType.OPERATIONS =>
      val r = OPERATIONS
      r
    case software.amazon.awssdk.services.account.model.AlternateContactType.SECURITY =>
      val r = SECURITY
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.account.model.AlternateContactType {
    override def unwrap
        : software.amazon.awssdk.services.account.model.AlternateContactType =
      software.amazon.awssdk.services.account.model.AlternateContactType.UNKNOWN_TO_SDK_VERSION
  }
  case object BILLING extends zio.aws.account.model.AlternateContactType {
    override def unwrap
        : software.amazon.awssdk.services.account.model.AlternateContactType =
      software.amazon.awssdk.services.account.model.AlternateContactType.BILLING
  }
  case object OPERATIONS extends zio.aws.account.model.AlternateContactType {
    override def unwrap
        : software.amazon.awssdk.services.account.model.AlternateContactType =
      software.amazon.awssdk.services.account.model.AlternateContactType.OPERATIONS
  }
  case object SECURITY extends zio.aws.account.model.AlternateContactType {
    override def unwrap
        : software.amazon.awssdk.services.account.model.AlternateContactType =
      software.amazon.awssdk.services.account.model.AlternateContactType.SECURITY
  }
}
