package zio.aws.account.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.account.model.primitives.{
  PostalCode,
  StateOrRegion,
  FullName,
  City,
  ContactInformationPhoneNumber,
  DistrictOrCounty,
  WebsiteUrl,
  AddressLine,
  CountryCode,
  CompanyName
}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ContactInformation(
    addressLine1: AddressLine,
    addressLine2: Optional[AddressLine] = Optional.Absent,
    addressLine3: Optional[AddressLine] = Optional.Absent,
    city: City,
    companyName: Optional[CompanyName] = Optional.Absent,
    countryCode: CountryCode,
    districtOrCounty: Optional[DistrictOrCounty] = Optional.Absent,
    fullName: FullName,
    phoneNumber: ContactInformationPhoneNumber,
    postalCode: PostalCode,
    stateOrRegion: Optional[StateOrRegion] = Optional.Absent,
    websiteUrl: Optional[WebsiteUrl] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.account.model.ContactInformation = {
    import ContactInformation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.account.model.ContactInformation
      .builder()
      .addressLine1(AddressLine.unwrap(addressLine1): java.lang.String)
      .optionallyWith(
        addressLine2.map(value => AddressLine.unwrap(value): java.lang.String)
      )(_.addressLine2)
      .optionallyWith(
        addressLine3.map(value => AddressLine.unwrap(value): java.lang.String)
      )(_.addressLine3)
      .city(City.unwrap(city): java.lang.String)
      .optionallyWith(
        companyName.map(value => CompanyName.unwrap(value): java.lang.String)
      )(_.companyName)
      .countryCode(CountryCode.unwrap(countryCode): java.lang.String)
      .optionallyWith(
        districtOrCounty.map(value =>
          DistrictOrCounty.unwrap(value): java.lang.String
        )
      )(_.districtOrCounty)
      .fullName(FullName.unwrap(fullName): java.lang.String)
      .phoneNumber(
        ContactInformationPhoneNumber.unwrap(phoneNumber): java.lang.String
      )
      .postalCode(PostalCode.unwrap(postalCode): java.lang.String)
      .optionallyWith(
        stateOrRegion.map(value =>
          StateOrRegion.unwrap(value): java.lang.String
        )
      )(_.stateOrRegion)
      .optionallyWith(
        websiteUrl.map(value => WebsiteUrl.unwrap(value): java.lang.String)
      )(_.websiteUrl)
      .build()
  }
  def asReadOnly: zio.aws.account.model.ContactInformation.ReadOnly =
    zio.aws.account.model.ContactInformation.wrap(buildAwsValue())
}
object ContactInformation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.account.model.ContactInformation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.account.model.ContactInformation =
      zio.aws.account.model.ContactInformation(
        addressLine1,
        addressLine2.map(value => value),
        addressLine3.map(value => value),
        city,
        companyName.map(value => value),
        countryCode,
        districtOrCounty.map(value => value),
        fullName,
        phoneNumber,
        postalCode,
        stateOrRegion.map(value => value),
        websiteUrl.map(value => value)
      )
    def addressLine1: AddressLine
    def addressLine2: Optional[AddressLine]
    def addressLine3: Optional[AddressLine]
    def city: City
    def companyName: Optional[CompanyName]
    def countryCode: CountryCode
    def districtOrCounty: Optional[DistrictOrCounty]
    def fullName: FullName
    def phoneNumber: ContactInformationPhoneNumber
    def postalCode: PostalCode
    def stateOrRegion: Optional[StateOrRegion]
    def websiteUrl: Optional[WebsiteUrl]
    def getAddressLine1: ZIO[Any, Nothing, AddressLine] =
      ZIO.succeed(addressLine1)
    def getAddressLine2: ZIO[Any, AwsError, AddressLine] =
      AwsError.unwrapOptionField("addressLine2", addressLine2)
    def getAddressLine3: ZIO[Any, AwsError, AddressLine] =
      AwsError.unwrapOptionField("addressLine3", addressLine3)
    def getCity: ZIO[Any, Nothing, City] = ZIO.succeed(city)
    def getCompanyName: ZIO[Any, AwsError, CompanyName] =
      AwsError.unwrapOptionField("companyName", companyName)
    def getCountryCode: ZIO[Any, Nothing, CountryCode] =
      ZIO.succeed(countryCode)
    def getDistrictOrCounty: ZIO[Any, AwsError, DistrictOrCounty] =
      AwsError.unwrapOptionField("districtOrCounty", districtOrCounty)
    def getFullName: ZIO[Any, Nothing, FullName] = ZIO.succeed(fullName)
    def getPhoneNumber: ZIO[Any, Nothing, ContactInformationPhoneNumber] =
      ZIO.succeed(phoneNumber)
    def getPostalCode: ZIO[Any, Nothing, PostalCode] = ZIO.succeed(postalCode)
    def getStateOrRegion: ZIO[Any, AwsError, StateOrRegion] =
      AwsError.unwrapOptionField("stateOrRegion", stateOrRegion)
    def getWebsiteUrl: ZIO[Any, AwsError, WebsiteUrl] =
      AwsError.unwrapOptionField("websiteUrl", websiteUrl)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.account.model.ContactInformation
  ) extends zio.aws.account.model.ContactInformation.ReadOnly {
    override val addressLine1: AddressLine =
      zio.aws.account.model.primitives.AddressLine(impl.addressLine1())
    override val addressLine2: Optional[AddressLine] = zio.aws.core.internal
      .optionalFromNullable(impl.addressLine2())
      .map(value => zio.aws.account.model.primitives.AddressLine(value))
    override val addressLine3: Optional[AddressLine] = zio.aws.core.internal
      .optionalFromNullable(impl.addressLine3())
      .map(value => zio.aws.account.model.primitives.AddressLine(value))
    override val city: City = zio.aws.account.model.primitives.City(impl.city())
    override val companyName: Optional[CompanyName] = zio.aws.core.internal
      .optionalFromNullable(impl.companyName())
      .map(value => zio.aws.account.model.primitives.CompanyName(value))
    override val countryCode: CountryCode =
      zio.aws.account.model.primitives.CountryCode(impl.countryCode())
    override val districtOrCounty: Optional[DistrictOrCounty] =
      zio.aws.core.internal
        .optionalFromNullable(impl.districtOrCounty())
        .map(value => zio.aws.account.model.primitives.DistrictOrCounty(value))
    override val fullName: FullName =
      zio.aws.account.model.primitives.FullName(impl.fullName())
    override val phoneNumber: ContactInformationPhoneNumber =
      zio.aws.account.model.primitives
        .ContactInformationPhoneNumber(impl.phoneNumber())
    override val postalCode: PostalCode =
      zio.aws.account.model.primitives.PostalCode(impl.postalCode())
    override val stateOrRegion: Optional[StateOrRegion] = zio.aws.core.internal
      .optionalFromNullable(impl.stateOrRegion())
      .map(value => zio.aws.account.model.primitives.StateOrRegion(value))
    override val websiteUrl: Optional[WebsiteUrl] = zio.aws.core.internal
      .optionalFromNullable(impl.websiteUrl())
      .map(value => zio.aws.account.model.primitives.WebsiteUrl(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.account.model.ContactInformation
  ): zio.aws.account.model.ContactInformation.ReadOnly = new Wrapper(impl)
}
