package zio.aws.account.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.account.model.primitives.AccountId
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DeleteAlternateContactRequest(
    accountId: Optional[AccountId] = Optional.Absent,
    alternateContactType: zio.aws.account.model.AlternateContactType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.account.model.DeleteAlternateContactRequest = {
    import DeleteAlternateContactRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.account.model.DeleteAlternateContactRequest
      .builder()
      .optionallyWith(
        accountId.map(value => AccountId.unwrap(value): java.lang.String)
      )(_.accountId)
      .alternateContactType(alternateContactType.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.account.model.DeleteAlternateContactRequest.ReadOnly =
    zio.aws.account.model.DeleteAlternateContactRequest.wrap(buildAwsValue())
}
object DeleteAlternateContactRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.account.model.DeleteAlternateContactRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.account.model.DeleteAlternateContactRequest =
      zio.aws.account.model.DeleteAlternateContactRequest(
        accountId.map(value => value),
        alternateContactType
      )
    def accountId: Optional[AccountId]
    def alternateContactType: zio.aws.account.model.AlternateContactType
    def getAccountId: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("accountId", accountId)
    def getAlternateContactType
        : ZIO[Any, Nothing, zio.aws.account.model.AlternateContactType] =
      ZIO.succeed(alternateContactType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.account.model.DeleteAlternateContactRequest
  ) extends zio.aws.account.model.DeleteAlternateContactRequest.ReadOnly {
    override val accountId: Optional[AccountId] = zio.aws.core.internal
      .optionalFromNullable(impl.accountId())
      .map(value => zio.aws.account.model.primitives.AccountId(value))
    override val alternateContactType
        : zio.aws.account.model.AlternateContactType =
      zio.aws.account.model.AlternateContactType
        .wrap(impl.alternateContactType())
  }
  def wrap(
      impl: software.amazon.awssdk.services.account.model.DeleteAlternateContactRequest
  ): zio.aws.account.model.DeleteAlternateContactRequest.ReadOnly = new Wrapper(
    impl
  )
}
