package zio.aws.account.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.account.model.primitives.{RegionName, AccountId}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DisableRegionRequest(
    accountId: Optional[AccountId] = Optional.Absent,
    regionName: RegionName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.account.model.DisableRegionRequest = {
    import DisableRegionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.account.model.DisableRegionRequest
      .builder()
      .optionallyWith(
        accountId.map(value => AccountId.unwrap(value): java.lang.String)
      )(_.accountId)
      .regionName(RegionName.unwrap(regionName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.account.model.DisableRegionRequest.ReadOnly =
    zio.aws.account.model.DisableRegionRequest.wrap(buildAwsValue())
}
object DisableRegionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.account.model.DisableRegionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.account.model.DisableRegionRequest =
      zio.aws.account.model
        .DisableRegionRequest(accountId.map(value => value), regionName)
    def accountId: Optional[AccountId]
    def regionName: RegionName
    def getAccountId: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("accountId", accountId)
    def getRegionName: ZIO[Any, Nothing, RegionName] = ZIO.succeed(regionName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.account.model.DisableRegionRequest
  ) extends zio.aws.account.model.DisableRegionRequest.ReadOnly {
    override val accountId: Optional[AccountId] = zio.aws.core.internal
      .optionalFromNullable(impl.accountId())
      .map(value => zio.aws.account.model.primitives.AccountId(value))
    override val regionName: RegionName =
      zio.aws.account.model.primitives.RegionName(impl.regionName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.account.model.DisableRegionRequest
  ): zio.aws.account.model.DisableRegionRequest.ReadOnly = new Wrapper(impl)
}
