package zio.aws.account.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.account.model.primitives.AccountId
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetAlternateContactRequest(
    accountId: Optional[AccountId] = Optional.Absent,
    alternateContactType: zio.aws.account.model.AlternateContactType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.account.model.GetAlternateContactRequest = {
    import GetAlternateContactRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.account.model.GetAlternateContactRequest
      .builder()
      .optionallyWith(
        accountId.map(value => AccountId.unwrap(value): java.lang.String)
      )(_.accountId)
      .alternateContactType(alternateContactType.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.account.model.GetAlternateContactRequest.ReadOnly =
    zio.aws.account.model.GetAlternateContactRequest.wrap(buildAwsValue())
}
object GetAlternateContactRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.account.model.GetAlternateContactRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.account.model.GetAlternateContactRequest =
      zio.aws.account.model.GetAlternateContactRequest(
        accountId.map(value => value),
        alternateContactType
      )
    def accountId: Optional[AccountId]
    def alternateContactType: zio.aws.account.model.AlternateContactType
    def getAccountId: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("accountId", accountId)
    def getAlternateContactType
        : ZIO[Any, Nothing, zio.aws.account.model.AlternateContactType] =
      ZIO.succeed(alternateContactType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.account.model.GetAlternateContactRequest
  ) extends zio.aws.account.model.GetAlternateContactRequest.ReadOnly {
    override val accountId: Optional[AccountId] = zio.aws.core.internal
      .optionalFromNullable(impl.accountId())
      .map(value => zio.aws.account.model.primitives.AccountId(value))
    override val alternateContactType
        : zio.aws.account.model.AlternateContactType =
      zio.aws.account.model.AlternateContactType
        .wrap(impl.alternateContactType())
  }
  def wrap(
      impl: software.amazon.awssdk.services.account.model.GetAlternateContactRequest
  ): zio.aws.account.model.GetAlternateContactRequest.ReadOnly = new Wrapper(
    impl
  )
}
