package zio.aws.account.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetAlternateContactResponse(
    alternateContact: Optional[zio.aws.account.model.AlternateContact] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.account.model.GetAlternateContactResponse = {
    import GetAlternateContactResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.account.model.GetAlternateContactResponse
      .builder()
      .optionallyWith(alternateContact.map(value => value.buildAwsValue()))(
        _.alternateContact
      )
      .build()
  }
  def asReadOnly: zio.aws.account.model.GetAlternateContactResponse.ReadOnly =
    zio.aws.account.model.GetAlternateContactResponse.wrap(buildAwsValue())
}
object GetAlternateContactResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.account.model.GetAlternateContactResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.account.model.GetAlternateContactResponse =
      zio.aws.account.model.GetAlternateContactResponse(
        alternateContact.map(value => value.asEditable)
      )
    def alternateContact
        : Optional[zio.aws.account.model.AlternateContact.ReadOnly]
    def getAlternateContact
        : ZIO[Any, AwsError, zio.aws.account.model.AlternateContact.ReadOnly] =
      AwsError.unwrapOptionField("alternateContact", alternateContact)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.account.model.GetAlternateContactResponse
  ) extends zio.aws.account.model.GetAlternateContactResponse.ReadOnly {
    override val alternateContact
        : Optional[zio.aws.account.model.AlternateContact.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.alternateContact())
        .map(value => zio.aws.account.model.AlternateContact.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.account.model.GetAlternateContactResponse
  ): zio.aws.account.model.GetAlternateContactResponse.ReadOnly = new Wrapper(
    impl
  )
}
