package zio.aws.account.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.account.model.primitives.AccountId
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetContactInformationRequest(
    accountId: Optional[AccountId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.account.model.GetContactInformationRequest = {
    import GetContactInformationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.account.model.GetContactInformationRequest
      .builder()
      .optionallyWith(
        accountId.map(value => AccountId.unwrap(value): java.lang.String)
      )(_.accountId)
      .build()
  }
  def asReadOnly: zio.aws.account.model.GetContactInformationRequest.ReadOnly =
    zio.aws.account.model.GetContactInformationRequest.wrap(buildAwsValue())
}
object GetContactInformationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.account.model.GetContactInformationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.account.model.GetContactInformationRequest =
      zio.aws.account.model
        .GetContactInformationRequest(accountId.map(value => value))
    def accountId: Optional[AccountId]
    def getAccountId: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("accountId", accountId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.account.model.GetContactInformationRequest
  ) extends zio.aws.account.model.GetContactInformationRequest.ReadOnly {
    override val accountId: Optional[AccountId] = zio.aws.core.internal
      .optionalFromNullable(impl.accountId())
      .map(value => zio.aws.account.model.primitives.AccountId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.account.model.GetContactInformationRequest
  ): zio.aws.account.model.GetContactInformationRequest.ReadOnly = new Wrapper(
    impl
  )
}
