package zio.aws.account.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetContactInformationResponse(
    contactInformation: Optional[zio.aws.account.model.ContactInformation] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.account.model.GetContactInformationResponse = {
    import GetContactInformationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.account.model.GetContactInformationResponse
      .builder()
      .optionallyWith(contactInformation.map(value => value.buildAwsValue()))(
        _.contactInformation
      )
      .build()
  }
  def asReadOnly: zio.aws.account.model.GetContactInformationResponse.ReadOnly =
    zio.aws.account.model.GetContactInformationResponse.wrap(buildAwsValue())
}
object GetContactInformationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.account.model.GetContactInformationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.account.model.GetContactInformationResponse =
      zio.aws.account.model.GetContactInformationResponse(
        contactInformation.map(value => value.asEditable)
      )
    def contactInformation
        : Optional[zio.aws.account.model.ContactInformation.ReadOnly]
    def getContactInformation: ZIO[
      Any,
      AwsError,
      zio.aws.account.model.ContactInformation.ReadOnly
    ] = AwsError.unwrapOptionField("contactInformation", contactInformation)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.account.model.GetContactInformationResponse
  ) extends zio.aws.account.model.GetContactInformationResponse.ReadOnly {
    override val contactInformation
        : Optional[zio.aws.account.model.ContactInformation.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.contactInformation())
        .map(value => zio.aws.account.model.ContactInformation.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.account.model.GetContactInformationResponse
  ): zio.aws.account.model.GetContactInformationResponse.ReadOnly = new Wrapper(
    impl
  )
}
