package zio.aws.account.model
import zio.prelude.data.Optional
import zio.aws.account.model.primitives.{
  ListRegionsRequestNextTokenString,
  ListRegionsRequestMaxResultsInteger,
  AccountId
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListRegionsRequest(
    accountId: Optional[AccountId] = Optional.Absent,
    maxResults: Optional[ListRegionsRequestMaxResultsInteger] = Optional.Absent,
    nextToken: Optional[ListRegionsRequestNextTokenString] = Optional.Absent,
    regionOptStatusContains: Optional[
      Iterable[zio.aws.account.model.RegionOptStatus]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.account.model.ListRegionsRequest = {
    import ListRegionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.account.model.ListRegionsRequest
      .builder()
      .optionallyWith(
        accountId.map(value => AccountId.unwrap(value): java.lang.String)
      )(_.accountId)
      .optionallyWith(
        maxResults.map(value =>
          ListRegionsRequestMaxResultsInteger.unwrap(value): Integer
        )
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value =>
          ListRegionsRequestNextTokenString.unwrap(value): java.lang.String
        )
      )(_.nextToken)
      .optionallyWith(
        regionOptStatusContains.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.regionOptStatusContainsWithStrings)
      .build()
  }
  def asReadOnly: zio.aws.account.model.ListRegionsRequest.ReadOnly =
    zio.aws.account.model.ListRegionsRequest.wrap(buildAwsValue())
}
object ListRegionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.account.model.ListRegionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.account.model.ListRegionsRequest =
      zio.aws.account.model.ListRegionsRequest(
        accountId.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value),
        regionOptStatusContains.map(value => value)
      )
    def accountId: Optional[AccountId]
    def maxResults: Optional[ListRegionsRequestMaxResultsInteger]
    def nextToken: Optional[ListRegionsRequestNextTokenString]
    def regionOptStatusContains
        : Optional[List[zio.aws.account.model.RegionOptStatus]]
    def getAccountId: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("accountId", accountId)
    def getMaxResults: ZIO[Any, AwsError, ListRegionsRequestMaxResultsInteger] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, ListRegionsRequestNextTokenString] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getRegionOptStatusContains
        : ZIO[Any, AwsError, List[zio.aws.account.model.RegionOptStatus]] =
      AwsError.unwrapOptionField(
        "regionOptStatusContains",
        regionOptStatusContains
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.account.model.ListRegionsRequest
  ) extends zio.aws.account.model.ListRegionsRequest.ReadOnly {
    override val accountId: Optional[AccountId] = zio.aws.core.internal
      .optionalFromNullable(impl.accountId())
      .map(value => zio.aws.account.model.primitives.AccountId(value))
    override val maxResults: Optional[ListRegionsRequestMaxResultsInteger] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.account.model.primitives
            .ListRegionsRequestMaxResultsInteger(value)
        )
    override val nextToken: Optional[ListRegionsRequestNextTokenString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.nextToken())
        .map(value =>
          zio.aws.account.model.primitives
            .ListRegionsRequestNextTokenString(value)
        )
    override val regionOptStatusContains
        : Optional[List[zio.aws.account.model.RegionOptStatus]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.regionOptStatusContains())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.account.model.RegionOptStatus.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.account.model.ListRegionsRequest
  ): zio.aws.account.model.ListRegionsRequest.ReadOnly = new Wrapper(impl)
}
