package zio.aws.account.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListRegionsResponse(
    nextToken: Optional[String] = Optional.Absent,
    regions: Optional[Iterable[zio.aws.account.model.Region]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.account.model.ListRegionsResponse = {
    import ListRegionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.account.model.ListRegionsResponse
      .builder()
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(
        regions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.regions)
      .build()
  }
  def asReadOnly: zio.aws.account.model.ListRegionsResponse.ReadOnly =
    zio.aws.account.model.ListRegionsResponse.wrap(buildAwsValue())
}
object ListRegionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.account.model.ListRegionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.account.model.ListRegionsResponse =
      zio.aws.account.model.ListRegionsResponse(
        nextToken.map(value => value),
        regions.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextToken: Optional[String]
    def regions: Optional[List[zio.aws.account.model.Region.ReadOnly]]
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getRegions
        : ZIO[Any, AwsError, List[zio.aws.account.model.Region.ReadOnly]] =
      AwsError.unwrapOptionField("regions", regions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.account.model.ListRegionsResponse
  ) extends zio.aws.account.model.ListRegionsResponse.ReadOnly {
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
    override val regions
        : Optional[List[zio.aws.account.model.Region.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.regions())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.account.model.Region.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.account.model.ListRegionsResponse
  ): zio.aws.account.model.ListRegionsResponse.ReadOnly = new Wrapper(impl)
}
