package zio.aws.account.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.account.model.primitives.{
  EmailAddress,
  AccountId,
  PhoneNumber,
  Title,
  Name
}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class PutAlternateContactRequest(
    accountId: Optional[AccountId] = Optional.Absent,
    alternateContactType: zio.aws.account.model.AlternateContactType,
    emailAddress: EmailAddress,
    name: Name,
    phoneNumber: PhoneNumber,
    title: Title
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.account.model.PutAlternateContactRequest = {
    import PutAlternateContactRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.account.model.PutAlternateContactRequest
      .builder()
      .optionallyWith(
        accountId.map(value => AccountId.unwrap(value): java.lang.String)
      )(_.accountId)
      .alternateContactType(alternateContactType.unwrap)
      .emailAddress(EmailAddress.unwrap(emailAddress): java.lang.String)
      .name(Name.unwrap(name): java.lang.String)
      .phoneNumber(PhoneNumber.unwrap(phoneNumber): java.lang.String)
      .title(Title.unwrap(title): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.account.model.PutAlternateContactRequest.ReadOnly =
    zio.aws.account.model.PutAlternateContactRequest.wrap(buildAwsValue())
}
object PutAlternateContactRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.account.model.PutAlternateContactRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.account.model.PutAlternateContactRequest =
      zio.aws.account.model.PutAlternateContactRequest(
        accountId.map(value => value),
        alternateContactType,
        emailAddress,
        name,
        phoneNumber,
        title
      )
    def accountId: Optional[AccountId]
    def alternateContactType: zio.aws.account.model.AlternateContactType
    def emailAddress: EmailAddress
    def name: Name
    def phoneNumber: PhoneNumber
    def title: Title
    def getAccountId: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("accountId", accountId)
    def getAlternateContactType
        : ZIO[Any, Nothing, zio.aws.account.model.AlternateContactType] =
      ZIO.succeed(alternateContactType)
    def getEmailAddress: ZIO[Any, Nothing, EmailAddress] =
      ZIO.succeed(emailAddress)
    def getName: ZIO[Any, Nothing, Name] = ZIO.succeed(name)
    def getPhoneNumber: ZIO[Any, Nothing, PhoneNumber] =
      ZIO.succeed(phoneNumber)
    def getTitle: ZIO[Any, Nothing, Title] = ZIO.succeed(title)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.account.model.PutAlternateContactRequest
  ) extends zio.aws.account.model.PutAlternateContactRequest.ReadOnly {
    override val accountId: Optional[AccountId] = zio.aws.core.internal
      .optionalFromNullable(impl.accountId())
      .map(value => zio.aws.account.model.primitives.AccountId(value))
    override val alternateContactType
        : zio.aws.account.model.AlternateContactType =
      zio.aws.account.model.AlternateContactType
        .wrap(impl.alternateContactType())
    override val emailAddress: EmailAddress =
      zio.aws.account.model.primitives.EmailAddress(impl.emailAddress())
    override val name: Name = zio.aws.account.model.primitives.Name(impl.name())
    override val phoneNumber: PhoneNumber =
      zio.aws.account.model.primitives.PhoneNumber(impl.phoneNumber())
    override val title: Title =
      zio.aws.account.model.primitives.Title(impl.title())
  }
  def wrap(
      impl: software.amazon.awssdk.services.account.model.PutAlternateContactRequest
  ): zio.aws.account.model.PutAlternateContactRequest.ReadOnly = new Wrapper(
    impl
  )
}
