package zio.aws.account.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.account.model.primitives.AccountId
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class PutContactInformationRequest(
    accountId: Optional[AccountId] = Optional.Absent,
    contactInformation: zio.aws.account.model.ContactInformation
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.account.model.PutContactInformationRequest = {
    import PutContactInformationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.account.model.PutContactInformationRequest
      .builder()
      .optionallyWith(
        accountId.map(value => AccountId.unwrap(value): java.lang.String)
      )(_.accountId)
      .contactInformation(contactInformation.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.account.model.PutContactInformationRequest.ReadOnly =
    zio.aws.account.model.PutContactInformationRequest.wrap(buildAwsValue())
}
object PutContactInformationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.account.model.PutContactInformationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.account.model.PutContactInformationRequest =
      zio.aws.account.model.PutContactInformationRequest(
        accountId.map(value => value),
        contactInformation.asEditable
      )
    def accountId: Optional[AccountId]
    def contactInformation: zio.aws.account.model.ContactInformation.ReadOnly
    def getAccountId: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("accountId", accountId)
    def getContactInformation
        : ZIO[Any, Nothing, zio.aws.account.model.ContactInformation.ReadOnly] =
      ZIO.succeed(contactInformation)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.account.model.PutContactInformationRequest
  ) extends zio.aws.account.model.PutContactInformationRequest.ReadOnly {
    override val accountId: Optional[AccountId] = zio.aws.core.internal
      .optionalFromNullable(impl.accountId())
      .map(value => zio.aws.account.model.primitives.AccountId(value))
    override val contactInformation
        : zio.aws.account.model.ContactInformation.ReadOnly =
      zio.aws.account.model.ContactInformation.wrap(impl.contactInformation())
  }
  def wrap(
      impl: software.amazon.awssdk.services.account.model.PutContactInformationRequest
  ): zio.aws.account.model.PutContactInformationRequest.ReadOnly = new Wrapper(
    impl
  )
}
