package zio.aws.account.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.account.model.primitives.RegionName
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class Region(
    regionName: Optional[RegionName] = Optional.Absent,
    regionOptStatus: Optional[zio.aws.account.model.RegionOptStatus] =
      Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.account.model.Region = {
    import Region.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.account.model.Region
      .builder()
      .optionallyWith(
        regionName.map(value => RegionName.unwrap(value): java.lang.String)
      )(_.regionName)
      .optionallyWith(regionOptStatus.map(value => value.unwrap))(
        _.regionOptStatus
      )
      .build()
  }
  def asReadOnly: zio.aws.account.model.Region.ReadOnly =
    zio.aws.account.model.Region.wrap(buildAwsValue())
}
object Region {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.account.model.Region] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.account.model.Region = zio.aws.account.model.Region(
      regionName.map(value => value),
      regionOptStatus.map(value => value)
    )
    def regionName: Optional[RegionName]
    def regionOptStatus: Optional[zio.aws.account.model.RegionOptStatus]
    def getRegionName: ZIO[Any, AwsError, RegionName] =
      AwsError.unwrapOptionField("regionName", regionName)
    def getRegionOptStatus
        : ZIO[Any, AwsError, zio.aws.account.model.RegionOptStatus] =
      AwsError.unwrapOptionField("regionOptStatus", regionOptStatus)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.account.model.Region
  ) extends zio.aws.account.model.Region.ReadOnly {
    override val regionName: Optional[RegionName] = zio.aws.core.internal
      .optionalFromNullable(impl.regionName())
      .map(value => zio.aws.account.model.primitives.RegionName(value))
    override val regionOptStatus
        : Optional[zio.aws.account.model.RegionOptStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.regionOptStatus())
        .map(value => zio.aws.account.model.RegionOptStatus.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.account.model.Region
  ): zio.aws.account.model.Region.ReadOnly = new Wrapper(impl)
}
