package zio.aws.account.model
import scala.jdk.CollectionConverters.*
sealed trait RegionOptStatus {
  def unwrap: software.amazon.awssdk.services.account.model.RegionOptStatus
}
object RegionOptStatus {
  def wrap(
      value: software.amazon.awssdk.services.account.model.RegionOptStatus
  ): zio.aws.account.model.RegionOptStatus = value match {
    case software.amazon.awssdk.services.account.model.RegionOptStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.account.model.RegionOptStatus.ENABLED =>
      val r = ENABLED
      r
    case software.amazon.awssdk.services.account.model.RegionOptStatus.ENABLING =>
      val r = ENABLING
      r
    case software.amazon.awssdk.services.account.model.RegionOptStatus.DISABLING =>
      val r = DISABLING
      r
    case software.amazon.awssdk.services.account.model.RegionOptStatus.DISABLED =>
      val r = DISABLED
      r
    case software.amazon.awssdk.services.account.model.RegionOptStatus.ENABLED_BY_DEFAULT =>
      val r = ENABLED_BY_DEFAULT
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.account.model.RegionOptStatus {
    override def unwrap
        : software.amazon.awssdk.services.account.model.RegionOptStatus =
      software.amazon.awssdk.services.account.model.RegionOptStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object ENABLED extends zio.aws.account.model.RegionOptStatus {
    override def unwrap
        : software.amazon.awssdk.services.account.model.RegionOptStatus =
      software.amazon.awssdk.services.account.model.RegionOptStatus.ENABLED
  }
  case object ENABLING extends zio.aws.account.model.RegionOptStatus {
    override def unwrap
        : software.amazon.awssdk.services.account.model.RegionOptStatus =
      software.amazon.awssdk.services.account.model.RegionOptStatus.ENABLING
  }
  case object DISABLING extends zio.aws.account.model.RegionOptStatus {
    override def unwrap
        : software.amazon.awssdk.services.account.model.RegionOptStatus =
      software.amazon.awssdk.services.account.model.RegionOptStatus.DISABLING
  }
  case object DISABLED extends zio.aws.account.model.RegionOptStatus {
    override def unwrap
        : software.amazon.awssdk.services.account.model.RegionOptStatus =
      software.amazon.awssdk.services.account.model.RegionOptStatus.DISABLED
  }
  case object ENABLED_BY_DEFAULT extends zio.aws.account.model.RegionOptStatus {
    override def unwrap
        : software.amazon.awssdk.services.account.model.RegionOptStatus =
      software.amazon.awssdk.services.account.model.RegionOptStatus.ENABLED_BY_DEFAULT
  }
}
