package zio.aws.apprunner.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.apprunner.model.primitives.{
  Timestamp,
  Integer,
  AutoScalingConfigurationName,
  AppRunnerResourceArn
}
import scala.jdk.CollectionConverters._
final case class AutoScalingConfiguration(
    autoScalingConfigurationArn: Optional[AppRunnerResourceArn] =
      Optional.Absent,
    autoScalingConfigurationName: Optional[AutoScalingConfigurationName] =
      Optional.Absent,
    autoScalingConfigurationRevision: Optional[Integer] = Optional.Absent,
    latest: Optional[Boolean] = Optional.Absent,
    status: Optional[zio.aws.apprunner.model.AutoScalingConfigurationStatus] =
      Optional.Absent,
    maxConcurrency: Optional[Integer] = Optional.Absent,
    minSize: Optional[Integer] = Optional.Absent,
    maxSize: Optional[Integer] = Optional.Absent,
    createdAt: Optional[Timestamp] = Optional.Absent,
    deletedAt: Optional[Timestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apprunner.model.AutoScalingConfiguration = {
    import AutoScalingConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apprunner.model.AutoScalingConfiguration
      .builder()
      .optionallyWith(
        autoScalingConfigurationArn.map(value =>
          AppRunnerResourceArn.unwrap(value): java.lang.String
        )
      )(_.autoScalingConfigurationArn)
      .optionallyWith(
        autoScalingConfigurationName.map(value =>
          AutoScalingConfigurationName.unwrap(value): java.lang.String
        )
      )(_.autoScalingConfigurationName)
      .optionallyWith(
        autoScalingConfigurationRevision.map(value => value: java.lang.Integer)
      )(_.autoScalingConfigurationRevision)
      .optionallyWith(latest.map(value => value: java.lang.Boolean))(_.latest)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(maxConcurrency.map(value => value: java.lang.Integer))(
        _.maxConcurrency
      )
      .optionallyWith(minSize.map(value => value: java.lang.Integer))(_.minSize)
      .optionallyWith(maxSize.map(value => value: java.lang.Integer))(_.maxSize)
      .optionallyWith(createdAt.map(value => Timestamp.unwrap(value): Instant))(
        _.createdAt
      )
      .optionallyWith(deletedAt.map(value => Timestamp.unwrap(value): Instant))(
        _.deletedAt
      )
      .build()
  }
  def asReadOnly: zio.aws.apprunner.model.AutoScalingConfiguration.ReadOnly =
    zio.aws.apprunner.model.AutoScalingConfiguration.wrap(buildAwsValue())
}
object AutoScalingConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apprunner.model.AutoScalingConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apprunner.model.AutoScalingConfiguration =
      zio.aws.apprunner.model.AutoScalingConfiguration(
        autoScalingConfigurationArn.map(value => value),
        autoScalingConfigurationName.map(value => value),
        autoScalingConfigurationRevision.map(value => value),
        latest.map(value => value),
        status.map(value => value),
        maxConcurrency.map(value => value),
        minSize.map(value => value),
        maxSize.map(value => value),
        createdAt.map(value => value),
        deletedAt.map(value => value)
      )
    def autoScalingConfigurationArn: Optional[AppRunnerResourceArn]
    def autoScalingConfigurationName: Optional[AutoScalingConfigurationName]
    def autoScalingConfigurationRevision: Optional[Integer]
    def latest: Optional[Boolean]
    def status: Optional[zio.aws.apprunner.model.AutoScalingConfigurationStatus]
    def maxConcurrency: Optional[Integer]
    def minSize: Optional[Integer]
    def maxSize: Optional[Integer]
    def createdAt: Optional[Timestamp]
    def deletedAt: Optional[Timestamp]
    def getAutoScalingConfigurationArn
        : ZIO[Any, AwsError, AppRunnerResourceArn] = AwsError.unwrapOptionField(
      "autoScalingConfigurationArn",
      autoScalingConfigurationArn
    )
    def getAutoScalingConfigurationName
        : ZIO[Any, AwsError, AutoScalingConfigurationName] =
      AwsError.unwrapOptionField(
        "autoScalingConfigurationName",
        autoScalingConfigurationName
      )
    def getAutoScalingConfigurationRevision: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField(
        "autoScalingConfigurationRevision",
        autoScalingConfigurationRevision
      )
    def getLatest: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("latest", latest)
    def getStatus: ZIO[
      Any,
      AwsError,
      zio.aws.apprunner.model.AutoScalingConfigurationStatus
    ] = AwsError.unwrapOptionField("status", status)
    def getMaxConcurrency: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("maxConcurrency", maxConcurrency)
    def getMinSize: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("minSize", minSize)
    def getMaxSize: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("maxSize", maxSize)
    def getCreatedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getDeletedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("deletedAt", deletedAt)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apprunner.model.AutoScalingConfiguration
  ) extends zio.aws.apprunner.model.AutoScalingConfiguration.ReadOnly {
    override val autoScalingConfigurationArn: Optional[AppRunnerResourceArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.autoScalingConfigurationArn())
        .map(value =>
          zio.aws.apprunner.model.primitives.AppRunnerResourceArn(value)
        )
    override val autoScalingConfigurationName
        : Optional[AutoScalingConfigurationName] = zio.aws.core.internal
      .optionalFromNullable(impl.autoScalingConfigurationName())
      .map(value =>
        zio.aws.apprunner.model.primitives.AutoScalingConfigurationName(value)
      )
    override val autoScalingConfigurationRevision: Optional[Integer] =
      zio.aws.core.internal
        .optionalFromNullable(impl.autoScalingConfigurationRevision())
        .map(value => value: Integer)
    override val latest: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.latest())
      .map(value => value: Boolean)
    override val status
        : Optional[zio.aws.apprunner.model.AutoScalingConfigurationStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value =>
          zio.aws.apprunner.model.AutoScalingConfigurationStatus.wrap(value)
        )
    override val maxConcurrency: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.maxConcurrency())
      .map(value => value: Integer)
    override val minSize: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.minSize())
      .map(value => value: Integer)
    override val maxSize: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.maxSize())
      .map(value => value: Integer)
    override val createdAt: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.createdAt())
      .map(value => zio.aws.apprunner.model.primitives.Timestamp(value))
    override val deletedAt: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.deletedAt())
      .map(value => zio.aws.apprunner.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.apprunner.model.AutoScalingConfiguration
  ): zio.aws.apprunner.model.AutoScalingConfiguration.ReadOnly = new Wrapper(
    impl
  )
}
