package zio.aws.apprunner.model
import zio.aws.apprunner.model.primitives.ObservabilityConfigurationName
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateObservabilityConfigurationRequest(
    observabilityConfigurationName: ObservabilityConfigurationName,
    traceConfiguration: Optional[zio.aws.apprunner.model.TraceConfiguration] =
      Optional.Absent,
    tags: Optional[Iterable[zio.aws.apprunner.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apprunner.model.CreateObservabilityConfigurationRequest = {
    import CreateObservabilityConfigurationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apprunner.model.CreateObservabilityConfigurationRequest
      .builder()
      .observabilityConfigurationName(
        ObservabilityConfigurationName.unwrap(
          observabilityConfigurationName
        ): java.lang.String
      )
      .optionallyWith(traceConfiguration.map(value => value.buildAwsValue()))(
        _.traceConfiguration
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : zio.aws.apprunner.model.CreateObservabilityConfigurationRequest.ReadOnly =
    zio.aws.apprunner.model.CreateObservabilityConfigurationRequest
      .wrap(buildAwsValue())
}
object CreateObservabilityConfigurationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apprunner.model.CreateObservabilityConfigurationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.apprunner.model.CreateObservabilityConfigurationRequest =
      zio.aws.apprunner.model.CreateObservabilityConfigurationRequest(
        observabilityConfigurationName,
        traceConfiguration.map(value => value.asEditable),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def observabilityConfigurationName: ObservabilityConfigurationName
    def traceConfiguration
        : Optional[zio.aws.apprunner.model.TraceConfiguration.ReadOnly]
    def tags: Optional[List[zio.aws.apprunner.model.Tag.ReadOnly]]
    def getObservabilityConfigurationName
        : ZIO[Any, Nothing, ObservabilityConfigurationName] =
      ZIO.succeed(observabilityConfigurationName)
    def getTraceConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.apprunner.model.TraceConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("traceConfiguration", traceConfiguration)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.apprunner.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apprunner.model.CreateObservabilityConfigurationRequest
  ) extends zio.aws.apprunner.model.CreateObservabilityConfigurationRequest.ReadOnly {
    override val observabilityConfigurationName
        : ObservabilityConfigurationName = zio.aws.apprunner.model.primitives
      .ObservabilityConfigurationName(impl.observabilityConfigurationName())
    override val traceConfiguration
        : Optional[zio.aws.apprunner.model.TraceConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.traceConfiguration())
        .map(value => zio.aws.apprunner.model.TraceConfiguration.wrap(value))
    override val tags: Optional[List[zio.aws.apprunner.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.apprunner.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.apprunner.model.CreateObservabilityConfigurationRequest
  ): zio.aws.apprunner.model.CreateObservabilityConfigurationRequest.ReadOnly =
    new Wrapper(impl)
}
