package zio.aws.apprunner.model
import zio.aws.apprunner.model.primitives.AppRunnerResourceArn
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteConnectionRequest(connectionArn: AppRunnerResourceArn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apprunner.model.DeleteConnectionRequest = {
    import DeleteConnectionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apprunner.model.DeleteConnectionRequest
      .builder()
      .connectionArn(
        AppRunnerResourceArn.unwrap(connectionArn): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.apprunner.model.DeleteConnectionRequest.ReadOnly =
    zio.aws.apprunner.model.DeleteConnectionRequest.wrap(buildAwsValue())
}
object DeleteConnectionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apprunner.model.DeleteConnectionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apprunner.model.DeleteConnectionRequest =
      zio.aws.apprunner.model.DeleteConnectionRequest(connectionArn)
    def connectionArn: AppRunnerResourceArn
    def getConnectionArn: ZIO[Any, Nothing, AppRunnerResourceArn] =
      ZIO.succeed(connectionArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apprunner.model.DeleteConnectionRequest
  ) extends zio.aws.apprunner.model.DeleteConnectionRequest.ReadOnly {
    override val connectionArn: AppRunnerResourceArn =
      zio.aws.apprunner.model.primitives
        .AppRunnerResourceArn(impl.connectionArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.apprunner.model.DeleteConnectionRequest
  ): zio.aws.apprunner.model.DeleteConnectionRequest.ReadOnly = new Wrapper(
    impl
  )
}
