package zio.aws.apprunner.model
import zio.aws.apprunner.model.primitives.AppRunnerResourceArn
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DescribeServiceRequest(serviceArn: AppRunnerResourceArn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apprunner.model.DescribeServiceRequest = {
    import DescribeServiceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apprunner.model.DescribeServiceRequest
      .builder()
      .serviceArn(AppRunnerResourceArn.unwrap(serviceArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.apprunner.model.DescribeServiceRequest.ReadOnly =
    zio.aws.apprunner.model.DescribeServiceRequest.wrap(buildAwsValue())
}
object DescribeServiceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apprunner.model.DescribeServiceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apprunner.model.DescribeServiceRequest =
      zio.aws.apprunner.model.DescribeServiceRequest(serviceArn)
    def serviceArn: AppRunnerResourceArn
    def getServiceArn: ZIO[Any, Nothing, AppRunnerResourceArn] =
      ZIO.succeed(serviceArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apprunner.model.DescribeServiceRequest
  ) extends zio.aws.apprunner.model.DescribeServiceRequest.ReadOnly {
    override val serviceArn: AppRunnerResourceArn =
      zio.aws.apprunner.model.primitives.AppRunnerResourceArn(impl.serviceArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.apprunner.model.DescribeServiceRequest
  ): zio.aws.apprunner.model.DescribeServiceRequest.ReadOnly = new Wrapper(impl)
}
