package zio.aws.apprunner.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class IngressVpcConfiguration(
    vpcId: Optional[String] = Optional.Absent,
    vpcEndpointId: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apprunner.model.IngressVpcConfiguration = {
    import IngressVpcConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apprunner.model.IngressVpcConfiguration
      .builder()
      .optionallyWith(vpcId.map(value => value: java.lang.String))(_.vpcId)
      .optionallyWith(vpcEndpointId.map(value => value: java.lang.String))(
        _.vpcEndpointId
      )
      .build()
  }
  def asReadOnly: zio.aws.apprunner.model.IngressVpcConfiguration.ReadOnly =
    zio.aws.apprunner.model.IngressVpcConfiguration.wrap(buildAwsValue())
}
object IngressVpcConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apprunner.model.IngressVpcConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apprunner.model.IngressVpcConfiguration =
      zio.aws.apprunner.model.IngressVpcConfiguration(
        vpcId.map(value => value),
        vpcEndpointId.map(value => value)
      )
    def vpcId: Optional[String]
    def vpcEndpointId: Optional[String]
    def getVpcId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("vpcId", vpcId)
    def getVpcEndpointId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("vpcEndpointId", vpcEndpointId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apprunner.model.IngressVpcConfiguration
  ) extends zio.aws.apprunner.model.IngressVpcConfiguration.ReadOnly {
    override val vpcId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.vpcId())
      .map(value => value: String)
    override val vpcEndpointId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.vpcEndpointId())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.apprunner.model.IngressVpcConfiguration
  ): zio.aws.apprunner.model.IngressVpcConfiguration.ReadOnly = new Wrapper(
    impl
  )
}
