package zio.aws.apprunner.model
import zio.aws.apprunner.model.primitives.{RoleArn, Memory, Cpu}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class InstanceConfiguration(
    cpu: Optional[Cpu] = Optional.Absent,
    memory: Optional[Memory] = Optional.Absent,
    instanceRoleArn: Optional[RoleArn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apprunner.model.InstanceConfiguration = {
    import InstanceConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apprunner.model.InstanceConfiguration
      .builder()
      .optionallyWith(cpu.map(value => Cpu.unwrap(value): java.lang.String))(
        _.cpu
      )
      .optionallyWith(
        memory.map(value => Memory.unwrap(value): java.lang.String)
      )(_.memory)
      .optionallyWith(
        instanceRoleArn.map(value => RoleArn.unwrap(value): java.lang.String)
      )(_.instanceRoleArn)
      .build()
  }
  def asReadOnly: zio.aws.apprunner.model.InstanceConfiguration.ReadOnly =
    zio.aws.apprunner.model.InstanceConfiguration.wrap(buildAwsValue())
}
object InstanceConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apprunner.model.InstanceConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apprunner.model.InstanceConfiguration =
      zio.aws.apprunner.model.InstanceConfiguration(
        cpu.map(value => value),
        memory.map(value => value),
        instanceRoleArn.map(value => value)
      )
    def cpu: Optional[Cpu]
    def memory: Optional[Memory]
    def instanceRoleArn: Optional[RoleArn]
    def getCpu: ZIO[Any, AwsError, Cpu] = AwsError.unwrapOptionField("cpu", cpu)
    def getMemory: ZIO[Any, AwsError, Memory] =
      AwsError.unwrapOptionField("memory", memory)
    def getInstanceRoleArn: ZIO[Any, AwsError, RoleArn] =
      AwsError.unwrapOptionField("instanceRoleArn", instanceRoleArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apprunner.model.InstanceConfiguration
  ) extends zio.aws.apprunner.model.InstanceConfiguration.ReadOnly {
    override val cpu: Optional[Cpu] = zio.aws.core.internal
      .optionalFromNullable(impl.cpu())
      .map(value => zio.aws.apprunner.model.primitives.Cpu(value))
    override val memory: Optional[Memory] = zio.aws.core.internal
      .optionalFromNullable(impl.memory())
      .map(value => zio.aws.apprunner.model.primitives.Memory(value))
    override val instanceRoleArn: Optional[RoleArn] = zio.aws.core.internal
      .optionalFromNullable(impl.instanceRoleArn())
      .map(value => zio.aws.apprunner.model.primitives.RoleArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.apprunner.model.InstanceConfiguration
  ): zio.aws.apprunner.model.InstanceConfiguration.ReadOnly = new Wrapper(impl)
}
