package zio.aws.apprunner.model
import zio.aws.apprunner.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListVpcIngressConnectionsResponse(
    vpcIngressConnectionSummaryList: Iterable[
      zio.aws.apprunner.model.VpcIngressConnectionSummary
    ],
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apprunner.model.ListVpcIngressConnectionsResponse = {
    import ListVpcIngressConnectionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apprunner.model.ListVpcIngressConnectionsResponse
      .builder()
      .vpcIngressConnectionSummaryList(vpcIngressConnectionSummaryList.map {
        item =>
          item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.apprunner.model.ListVpcIngressConnectionsResponse.ReadOnly =
    zio.aws.apprunner.model.ListVpcIngressConnectionsResponse
      .wrap(buildAwsValue())
}
object ListVpcIngressConnectionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apprunner.model.ListVpcIngressConnectionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apprunner.model.ListVpcIngressConnectionsResponse =
      zio.aws.apprunner.model.ListVpcIngressConnectionsResponse(
        vpcIngressConnectionSummaryList.map { item =>
          item.asEditable
        },
        nextToken.map(value => value)
      )
    def vpcIngressConnectionSummaryList
        : List[zio.aws.apprunner.model.VpcIngressConnectionSummary.ReadOnly]
    def nextToken: Optional[NextToken]
    def getVpcIngressConnectionSummaryList: ZIO[Any, Nothing, List[
      zio.aws.apprunner.model.VpcIngressConnectionSummary.ReadOnly
    ]] = ZIO.succeed(vpcIngressConnectionSummaryList)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apprunner.model.ListVpcIngressConnectionsResponse
  ) extends zio.aws.apprunner.model.ListVpcIngressConnectionsResponse.ReadOnly {
    override val vpcIngressConnectionSummaryList
        : List[zio.aws.apprunner.model.VpcIngressConnectionSummary.ReadOnly] =
      impl
        .vpcIngressConnectionSummaryList()
        .asScala
        .map { item =>
          zio.aws.apprunner.model.VpcIngressConnectionSummary.wrap(item)
        }
        .toList
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.apprunner.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.apprunner.model.ListVpcIngressConnectionsResponse
  ): zio.aws.apprunner.model.ListVpcIngressConnectionsResponse.ReadOnly =
    new Wrapper(impl)
}
