package zio.aws.apprunner.model
import scala.jdk.CollectionConverters._
sealed trait Runtime {
  def unwrap: software.amazon.awssdk.services.apprunner.model.Runtime
}
object Runtime {
  def wrap(
      value: software.amazon.awssdk.services.apprunner.model.Runtime
  ): zio.aws.apprunner.model.Runtime = value match {
    case software.amazon.awssdk.services.apprunner.model.Runtime.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.apprunner.model.Runtime.PYTHON_3 =>
      val r = PYTHON_3
      r
    case software.amazon.awssdk.services.apprunner.model.Runtime.NODEJS_12 =>
      val r = NODEJS_12
      r
    case software.amazon.awssdk.services.apprunner.model.Runtime.NODEJS_14 =>
      val r = NODEJS_14
      r
    case software.amazon.awssdk.services.apprunner.model.Runtime.CORRETTO_8 =>
      val r = CORRETTO_8
      r
    case software.amazon.awssdk.services.apprunner.model.Runtime.CORRETTO_11 =>
      val r = CORRETTO_11
      r
    case software.amazon.awssdk.services.apprunner.model.Runtime.NODEJS_16 =>
      val r = NODEJS_16
      r
    case software.amazon.awssdk.services.apprunner.model.Runtime.GO_1 =>
      val r = GO_1
      r
    case software.amazon.awssdk.services.apprunner.model.Runtime.DOTNET_6 =>
      val r = DOTNET_6
      r
    case software.amazon.awssdk.services.apprunner.model.Runtime.PHP_81 =>
      val r = PHP_81
      r
    case software.amazon.awssdk.services.apprunner.model.Runtime.RUBY_31 =>
      val r = RUBY_31
      r
  }
  case object unknownToSdkVersion extends zio.aws.apprunner.model.Runtime {
    override def unwrap
        : software.amazon.awssdk.services.apprunner.model.Runtime =
      software.amazon.awssdk.services.apprunner.model.Runtime.UNKNOWN_TO_SDK_VERSION
  }
  case object PYTHON_3 extends zio.aws.apprunner.model.Runtime {
    override def unwrap
        : software.amazon.awssdk.services.apprunner.model.Runtime =
      software.amazon.awssdk.services.apprunner.model.Runtime.PYTHON_3
  }
  case object NODEJS_12 extends zio.aws.apprunner.model.Runtime {
    override def unwrap
        : software.amazon.awssdk.services.apprunner.model.Runtime =
      software.amazon.awssdk.services.apprunner.model.Runtime.NODEJS_12
  }
  case object NODEJS_14 extends zio.aws.apprunner.model.Runtime {
    override def unwrap
        : software.amazon.awssdk.services.apprunner.model.Runtime =
      software.amazon.awssdk.services.apprunner.model.Runtime.NODEJS_14
  }
  case object CORRETTO_8 extends zio.aws.apprunner.model.Runtime {
    override def unwrap
        : software.amazon.awssdk.services.apprunner.model.Runtime =
      software.amazon.awssdk.services.apprunner.model.Runtime.CORRETTO_8
  }
  case object CORRETTO_11 extends zio.aws.apprunner.model.Runtime {
    override def unwrap
        : software.amazon.awssdk.services.apprunner.model.Runtime =
      software.amazon.awssdk.services.apprunner.model.Runtime.CORRETTO_11
  }
  case object NODEJS_16 extends zio.aws.apprunner.model.Runtime {
    override def unwrap
        : software.amazon.awssdk.services.apprunner.model.Runtime =
      software.amazon.awssdk.services.apprunner.model.Runtime.NODEJS_16
  }
  case object GO_1 extends zio.aws.apprunner.model.Runtime {
    override def unwrap
        : software.amazon.awssdk.services.apprunner.model.Runtime =
      software.amazon.awssdk.services.apprunner.model.Runtime.GO_1
  }
  case object DOTNET_6 extends zio.aws.apprunner.model.Runtime {
    override def unwrap
        : software.amazon.awssdk.services.apprunner.model.Runtime =
      software.amazon.awssdk.services.apprunner.model.Runtime.DOTNET_6
  }
  case object PHP_81 extends zio.aws.apprunner.model.Runtime {
    override def unwrap
        : software.amazon.awssdk.services.apprunner.model.Runtime =
      software.amazon.awssdk.services.apprunner.model.Runtime.PHP_81
  }
  case object RUBY_31 extends zio.aws.apprunner.model.Runtime {
    override def unwrap
        : software.amazon.awssdk.services.apprunner.model.Runtime =
      software.amazon.awssdk.services.apprunner.model.Runtime.RUBY_31
  }
}
