package zio.aws.apprunner.model
import zio.aws.apprunner.model.primitives.NullableBoolean
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class SourceConfiguration(
    codeRepository: Optional[zio.aws.apprunner.model.CodeRepository] =
      Optional.Absent,
    imageRepository: Optional[zio.aws.apprunner.model.ImageRepository] =
      Optional.Absent,
    autoDeploymentsEnabled: Optional[NullableBoolean] = Optional.Absent,
    authenticationConfiguration: Optional[
      zio.aws.apprunner.model.AuthenticationConfiguration
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apprunner.model.SourceConfiguration = {
    import SourceConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apprunner.model.SourceConfiguration
      .builder()
      .optionallyWith(codeRepository.map(value => value.buildAwsValue()))(
        _.codeRepository
      )
      .optionallyWith(imageRepository.map(value => value.buildAwsValue()))(
        _.imageRepository
      )
      .optionallyWith(
        autoDeploymentsEnabled.map(value => value: java.lang.Boolean)
      )(_.autoDeploymentsEnabled)
      .optionallyWith(
        authenticationConfiguration.map(value => value.buildAwsValue())
      )(_.authenticationConfiguration)
      .build()
  }
  def asReadOnly: zio.aws.apprunner.model.SourceConfiguration.ReadOnly =
    zio.aws.apprunner.model.SourceConfiguration.wrap(buildAwsValue())
}
object SourceConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apprunner.model.SourceConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apprunner.model.SourceConfiguration =
      zio.aws.apprunner.model.SourceConfiguration(
        codeRepository.map(value => value.asEditable),
        imageRepository.map(value => value.asEditable),
        autoDeploymentsEnabled.map(value => value),
        authenticationConfiguration.map(value => value.asEditable)
      )
    def codeRepository
        : Optional[zio.aws.apprunner.model.CodeRepository.ReadOnly]
    def imageRepository
        : Optional[zio.aws.apprunner.model.ImageRepository.ReadOnly]
    def autoDeploymentsEnabled: Optional[NullableBoolean]
    def authenticationConfiguration
        : Optional[zio.aws.apprunner.model.AuthenticationConfiguration.ReadOnly]
    def getCodeRepository
        : ZIO[Any, AwsError, zio.aws.apprunner.model.CodeRepository.ReadOnly] =
      AwsError.unwrapOptionField("codeRepository", codeRepository)
    def getImageRepository
        : ZIO[Any, AwsError, zio.aws.apprunner.model.ImageRepository.ReadOnly] =
      AwsError.unwrapOptionField("imageRepository", imageRepository)
    def getAutoDeploymentsEnabled: ZIO[Any, AwsError, NullableBoolean] =
      AwsError.unwrapOptionField(
        "autoDeploymentsEnabled",
        autoDeploymentsEnabled
      )
    def getAuthenticationConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.apprunner.model.AuthenticationConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "authenticationConfiguration",
      authenticationConfiguration
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apprunner.model.SourceConfiguration
  ) extends zio.aws.apprunner.model.SourceConfiguration.ReadOnly {
    override val codeRepository
        : Optional[zio.aws.apprunner.model.CodeRepository.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.codeRepository())
        .map(value => zio.aws.apprunner.model.CodeRepository.wrap(value))
    override val imageRepository
        : Optional[zio.aws.apprunner.model.ImageRepository.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.imageRepository())
        .map(value => zio.aws.apprunner.model.ImageRepository.wrap(value))
    override val autoDeploymentsEnabled: Optional[NullableBoolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.autoDeploymentsEnabled())
        .map(value => value: NullableBoolean)
    override val authenticationConfiguration: Optional[
      zio.aws.apprunner.model.AuthenticationConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.authenticationConfiguration())
      .map(value =>
        zio.aws.apprunner.model.AuthenticationConfiguration.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.apprunner.model.SourceConfiguration
  ): zio.aws.apprunner.model.SourceConfiguration.ReadOnly = new Wrapper(impl)
}
