package zio.aws.apprunner.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.apprunner.model.primitives.{
  CustomerAccountId,
  Timestamp,
  DomainName,
  VpcIngressConnectionName,
  AppRunnerResourceArn
}
import scala.jdk.CollectionConverters._
final case class VpcIngressConnection(
    vpcIngressConnectionArn: Optional[AppRunnerResourceArn] = Optional.Absent,
    vpcIngressConnectionName: Optional[VpcIngressConnectionName] =
      Optional.Absent,
    serviceArn: Optional[AppRunnerResourceArn] = Optional.Absent,
    status: Optional[zio.aws.apprunner.model.VpcIngressConnectionStatus] =
      Optional.Absent,
    accountId: Optional[CustomerAccountId] = Optional.Absent,
    domainName: Optional[DomainName] = Optional.Absent,
    ingressVpcConfiguration: Optional[
      zio.aws.apprunner.model.IngressVpcConfiguration
    ] = Optional.Absent,
    createdAt: Optional[Timestamp] = Optional.Absent,
    deletedAt: Optional[Timestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apprunner.model.VpcIngressConnection = {
    import VpcIngressConnection.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apprunner.model.VpcIngressConnection
      .builder()
      .optionallyWith(
        vpcIngressConnectionArn.map(value =>
          AppRunnerResourceArn.unwrap(value): java.lang.String
        )
      )(_.vpcIngressConnectionArn)
      .optionallyWith(
        vpcIngressConnectionName.map(value =>
          VpcIngressConnectionName.unwrap(value): java.lang.String
        )
      )(_.vpcIngressConnectionName)
      .optionallyWith(
        serviceArn.map(value =>
          AppRunnerResourceArn.unwrap(value): java.lang.String
        )
      )(_.serviceArn)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        accountId.map(value =>
          CustomerAccountId.unwrap(value): java.lang.String
        )
      )(_.accountId)
      .optionallyWith(
        domainName.map(value => DomainName.unwrap(value): java.lang.String)
      )(_.domainName)
      .optionallyWith(
        ingressVpcConfiguration.map(value => value.buildAwsValue())
      )(_.ingressVpcConfiguration)
      .optionallyWith(createdAt.map(value => Timestamp.unwrap(value): Instant))(
        _.createdAt
      )
      .optionallyWith(deletedAt.map(value => Timestamp.unwrap(value): Instant))(
        _.deletedAt
      )
      .build()
  }
  def asReadOnly: zio.aws.apprunner.model.VpcIngressConnection.ReadOnly =
    zio.aws.apprunner.model.VpcIngressConnection.wrap(buildAwsValue())
}
object VpcIngressConnection {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apprunner.model.VpcIngressConnection
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apprunner.model.VpcIngressConnection =
      zio.aws.apprunner.model.VpcIngressConnection(
        vpcIngressConnectionArn.map(value => value),
        vpcIngressConnectionName.map(value => value),
        serviceArn.map(value => value),
        status.map(value => value),
        accountId.map(value => value),
        domainName.map(value => value),
        ingressVpcConfiguration.map(value => value.asEditable),
        createdAt.map(value => value),
        deletedAt.map(value => value)
      )
    def vpcIngressConnectionArn: Optional[AppRunnerResourceArn]
    def vpcIngressConnectionName: Optional[VpcIngressConnectionName]
    def serviceArn: Optional[AppRunnerResourceArn]
    def status: Optional[zio.aws.apprunner.model.VpcIngressConnectionStatus]
    def accountId: Optional[CustomerAccountId]
    def domainName: Optional[DomainName]
    def ingressVpcConfiguration
        : Optional[zio.aws.apprunner.model.IngressVpcConfiguration.ReadOnly]
    def createdAt: Optional[Timestamp]
    def deletedAt: Optional[Timestamp]
    def getVpcIngressConnectionArn: ZIO[Any, AwsError, AppRunnerResourceArn] =
      AwsError.unwrapOptionField(
        "vpcIngressConnectionArn",
        vpcIngressConnectionArn
      )
    def getVpcIngressConnectionName
        : ZIO[Any, AwsError, VpcIngressConnectionName] = AwsError
      .unwrapOptionField("vpcIngressConnectionName", vpcIngressConnectionName)
    def getServiceArn: ZIO[Any, AwsError, AppRunnerResourceArn] =
      AwsError.unwrapOptionField("serviceArn", serviceArn)
    def getStatus: ZIO[
      Any,
      AwsError,
      zio.aws.apprunner.model.VpcIngressConnectionStatus
    ] = AwsError.unwrapOptionField("status", status)
    def getAccountId: ZIO[Any, AwsError, CustomerAccountId] =
      AwsError.unwrapOptionField("accountId", accountId)
    def getDomainName: ZIO[Any, AwsError, DomainName] =
      AwsError.unwrapOptionField("domainName", domainName)
    def getIngressVpcConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.apprunner.model.IngressVpcConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "ingressVpcConfiguration",
      ingressVpcConfiguration
    )
    def getCreatedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getDeletedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("deletedAt", deletedAt)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apprunner.model.VpcIngressConnection
  ) extends zio.aws.apprunner.model.VpcIngressConnection.ReadOnly {
    override val vpcIngressConnectionArn: Optional[AppRunnerResourceArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.vpcIngressConnectionArn())
        .map(value =>
          zio.aws.apprunner.model.primitives.AppRunnerResourceArn(value)
        )
    override val vpcIngressConnectionName: Optional[VpcIngressConnectionName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.vpcIngressConnectionName())
        .map(value =>
          zio.aws.apprunner.model.primitives.VpcIngressConnectionName(value)
        )
    override val serviceArn: Optional[AppRunnerResourceArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.serviceArn())
        .map(value =>
          zio.aws.apprunner.model.primitives.AppRunnerResourceArn(value)
        )
    override val status
        : Optional[zio.aws.apprunner.model.VpcIngressConnectionStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value =>
          zio.aws.apprunner.model.VpcIngressConnectionStatus.wrap(value)
        )
    override val accountId: Optional[CustomerAccountId] = zio.aws.core.internal
      .optionalFromNullable(impl.accountId())
      .map(value => zio.aws.apprunner.model.primitives.CustomerAccountId(value))
    override val domainName: Optional[DomainName] = zio.aws.core.internal
      .optionalFromNullable(impl.domainName())
      .map(value => zio.aws.apprunner.model.primitives.DomainName(value))
    override val ingressVpcConfiguration
        : Optional[zio.aws.apprunner.model.IngressVpcConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ingressVpcConfiguration())
        .map(value =>
          zio.aws.apprunner.model.IngressVpcConfiguration.wrap(value)
        )
    override val createdAt: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.createdAt())
      .map(value => zio.aws.apprunner.model.primitives.Timestamp(value))
    override val deletedAt: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.deletedAt())
      .map(value => zio.aws.apprunner.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.apprunner.model.VpcIngressConnection
  ): zio.aws.apprunner.model.VpcIngressConnection.ReadOnly = new Wrapper(impl)
}
