package zio.aws.apprunner.model
import zio.aws.apprunner.model.primitives.AppRunnerResourceArn
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class VpcIngressConnectionSummary(
    vpcIngressConnectionArn: Optional[AppRunnerResourceArn] = Optional.Absent,
    serviceArn: Optional[AppRunnerResourceArn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apprunner.model.VpcIngressConnectionSummary = {
    import VpcIngressConnectionSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apprunner.model.VpcIngressConnectionSummary
      .builder()
      .optionallyWith(
        vpcIngressConnectionArn.map(value =>
          AppRunnerResourceArn.unwrap(value): java.lang.String
        )
      )(_.vpcIngressConnectionArn)
      .optionallyWith(
        serviceArn.map(value =>
          AppRunnerResourceArn.unwrap(value): java.lang.String
        )
      )(_.serviceArn)
      .build()
  }
  def asReadOnly: zio.aws.apprunner.model.VpcIngressConnectionSummary.ReadOnly =
    zio.aws.apprunner.model.VpcIngressConnectionSummary.wrap(buildAwsValue())
}
object VpcIngressConnectionSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apprunner.model.VpcIngressConnectionSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apprunner.model.VpcIngressConnectionSummary =
      zio.aws.apprunner.model.VpcIngressConnectionSummary(
        vpcIngressConnectionArn.map(value => value),
        serviceArn.map(value => value)
      )
    def vpcIngressConnectionArn: Optional[AppRunnerResourceArn]
    def serviceArn: Optional[AppRunnerResourceArn]
    def getVpcIngressConnectionArn: ZIO[Any, AwsError, AppRunnerResourceArn] =
      AwsError.unwrapOptionField(
        "vpcIngressConnectionArn",
        vpcIngressConnectionArn
      )
    def getServiceArn: ZIO[Any, AwsError, AppRunnerResourceArn] =
      AwsError.unwrapOptionField("serviceArn", serviceArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apprunner.model.VpcIngressConnectionSummary
  ) extends zio.aws.apprunner.model.VpcIngressConnectionSummary.ReadOnly {
    override val vpcIngressConnectionArn: Optional[AppRunnerResourceArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.vpcIngressConnectionArn())
        .map(value =>
          zio.aws.apprunner.model.primitives.AppRunnerResourceArn(value)
        )
    override val serviceArn: Optional[AppRunnerResourceArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.serviceArn())
        .map(value =>
          zio.aws.apprunner.model.primitives.AppRunnerResourceArn(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.apprunner.model.VpcIngressConnectionSummary
  ): zio.aws.apprunner.model.VpcIngressConnectionSummary.ReadOnly = new Wrapper(
    impl
  )
}
