package zio.aws.chimesdkmeetings.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class AttendeeCapabilities(
    audio: zio.aws.chimesdkmeetings.model.MediaCapabilities,
    video: zio.aws.chimesdkmeetings.model.MediaCapabilities,
    content: zio.aws.chimesdkmeetings.model.MediaCapabilities
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkmeetings.model.AttendeeCapabilities = {
    import AttendeeCapabilities.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkmeetings.model.AttendeeCapabilities
      .builder()
      .audio(audio.unwrap)
      .video(video.unwrap)
      .content(content.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.chimesdkmeetings.model.AttendeeCapabilities.ReadOnly =
    zio.aws.chimesdkmeetings.model.AttendeeCapabilities.wrap(buildAwsValue())
}
object AttendeeCapabilities {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkmeetings.model.AttendeeCapabilities
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chimesdkmeetings.model.AttendeeCapabilities =
      zio.aws.chimesdkmeetings.model.AttendeeCapabilities(audio, video, content)
    def audio: zio.aws.chimesdkmeetings.model.MediaCapabilities
    def video: zio.aws.chimesdkmeetings.model.MediaCapabilities
    def content: zio.aws.chimesdkmeetings.model.MediaCapabilities
    def getAudio
        : ZIO[Any, Nothing, zio.aws.chimesdkmeetings.model.MediaCapabilities] =
      ZIO.succeed(audio)
    def getVideo
        : ZIO[Any, Nothing, zio.aws.chimesdkmeetings.model.MediaCapabilities] =
      ZIO.succeed(video)
    def getContent
        : ZIO[Any, Nothing, zio.aws.chimesdkmeetings.model.MediaCapabilities] =
      ZIO.succeed(content)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkmeetings.model.AttendeeCapabilities
  ) extends zio.aws.chimesdkmeetings.model.AttendeeCapabilities.ReadOnly {
    override val audio: zio.aws.chimesdkmeetings.model.MediaCapabilities =
      zio.aws.chimesdkmeetings.model.MediaCapabilities.wrap(impl.audio())
    override val video: zio.aws.chimesdkmeetings.model.MediaCapabilities =
      zio.aws.chimesdkmeetings.model.MediaCapabilities.wrap(impl.video())
    override val content: zio.aws.chimesdkmeetings.model.MediaCapabilities =
      zio.aws.chimesdkmeetings.model.MediaCapabilities.wrap(impl.content())
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkmeetings.model.AttendeeCapabilities
  ): zio.aws.chimesdkmeetings.model.AttendeeCapabilities.ReadOnly = new Wrapper(
    impl
  )
}
