package zio.aws.chimesdkmeetings.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.chimesdkmeetings.model.primitives.GuidString
import scala.jdk.CollectionConverters._
final case class AttendeeIdItem(attendeeId: GuidString) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkmeetings.model.AttendeeIdItem = {
    import AttendeeIdItem.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkmeetings.model.AttendeeIdItem
      .builder()
      .attendeeId(GuidString.unwrap(attendeeId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.chimesdkmeetings.model.AttendeeIdItem.ReadOnly =
    zio.aws.chimesdkmeetings.model.AttendeeIdItem.wrap(buildAwsValue())
}
object AttendeeIdItem {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkmeetings.model.AttendeeIdItem
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chimesdkmeetings.model.AttendeeIdItem =
      zio.aws.chimesdkmeetings.model.AttendeeIdItem(attendeeId)
    def attendeeId: GuidString
    def getAttendeeId: ZIO[Any, Nothing, GuidString] = ZIO.succeed(attendeeId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkmeetings.model.AttendeeIdItem
  ) extends zio.aws.chimesdkmeetings.model.AttendeeIdItem.ReadOnly {
    override val attendeeId: GuidString =
      zio.aws.chimesdkmeetings.model.primitives.GuidString(impl.attendeeId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkmeetings.model.AttendeeIdItem
  ): zio.aws.chimesdkmeetings.model.AttendeeIdItem.ReadOnly = new Wrapper(impl)
}
